import { QueryChainCommand, Sort, UpdateData } from '@alipay/faas-db-builder';
import { UpdateAndReturnDocumentResult, UpdateAndReturnParamWithCallback } from '../types';
import type { AddDocumentParam, AddDocumentParamWithCallback, AddDocumentResult, CallbackParam, CountDocumentResult, CreateDatabaseOptions, DeleteDocumentResult, UpdateDataParamWithCallback, UpdateDocumentResult } from '../types';
import { Aggregate } from './Aggregate';
import { Document } from './Document';
import { Query } from './Query';
export declare class Collection {
    private readonly options;
    private readonly collectionName;
    private readonly builder;
    constructor(collectionName: string, options: CreateDatabaseOptions);
    add(param: AddDocumentParam): Promise<AddDocumentResult>;
    add(param: AddDocumentParamWithCallback): void;
    doc(_id: string): Document;
    limit(limit: number): Query;
    skip(skip: number): Query;
    where(match: QueryChainCommand): Query;
    projection(projection: object): Query;
    field(projection: object): Query;
    orderBy(field: string, sort: Sort): Query;
    aggregate(): Aggregate;
    update(data: UpdateData): Promise<UpdateDocumentResult>;
    update(data: UpdateDataParamWithCallback): void;
    updateAndReturn<T = any>(data: UpdateData): Promise<UpdateAndReturnDocumentResult<T>>;
    updateAndReturn<T = any>(data: UpdateAndReturnParamWithCallback<T>): void;
    set(data: UpdateData): Promise<UpdateDocumentResult>;
    set(data: UpdateDataParamWithCallback): void;
    remove(): Promise<DeleteDocumentResult>;
    remove(data: CallbackParam<DeleteDocumentResult>): void;
    get<T = any>(): Promise<Array<T>>;
    get<T = any>(param: CallbackParam<Array<T>>): void;
    count(): Promise<CountDocumentResult>;
    count(param: CallbackParam<CountDocumentResult>): void;
    private getDocumentPath;
}
