/*
 * Copyright (c) 2023 Huawei Device Co., Ltd.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS;
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * @file
 * @kit InputKit
 */
/**
 * IntentionCode
 *
 * @enum { number }
 * @syscap SystemCapability.MultimodalInput.Input.Core
 * @since 10
 */
/**
 * IntentionCode
 *
 * @enum { number }
 * @syscap SystemCapability.MultimodalInput.Input.Core
 * @atomicservice
 * @since 12
 */
export declare enum IntentionCode {
    /**
     * INTENTION_UNKNOWN
     *
     * @syscap SystemCapability.MultimodalInput.Input.Core
     * @since 10
     */
    /**
     * INTENTION_UNKNOWN
     *
     * @syscap SystemCapability.MultimodalInput.Input.Core
     * @atomicservice
     * @since 12
     */
    INTENTION_UNKNOWN = -1,
    /**
     * INTENTION_UP
     *
     * @syscap SystemCapability.MultimodalInput.Input.Core
     * @since 10
     */
    /**
     * INTENTION_UP
     *
     * @syscap SystemCapability.MultimodalInput.Input.Core
     * @atomicservice
     * @since 12
     */
    INTENTION_UP = 1,
    /**
     * INTENTION_DOWN
     *
     * @syscap SystemCapability.MultimodalInput.Input.Core
     * @since 10
     */
    /**
     * INTENTION_DOWN
     *
     * @syscap SystemCapability.MultimodalInput.Input.Core
     * @atomicservice
     * @since 12
     */
    INTENTION_DOWN = 2,
    /**
     * INTENTION_LEFT
     *
     * @syscap SystemCapability.MultimodalInput.Input.Core
     * @since 10
     */
    /**
     * INTENTION_LEFT
     *
     * @syscap SystemCapability.MultimodalInput.Input.Core
     * @atomicservice
     * @since 12
     */
    INTENTION_LEFT = 3,
    /**
     * INTENTION_RIGHT
     *
     * @syscap SystemCapability.MultimodalInput.Input.Core
     * @since 10
     */
    /**
     * INTENTION_RIGHT
     *
     * @syscap SystemCapability.MultimodalInput.Input.Core
     * @atomicservice
     * @since 12
     */
    INTENTION_RIGHT = 4,
    /**
     * INTENTION_SELECT
     *
     * @syscap SystemCapability.MultimodalInput.Input.Core
     * @since 10
     */
    /**
     * INTENTION_SELECT
     *
     * @syscap SystemCapability.MultimodalInput.Input.Core
     * @atomicservice
     * @since 12
     */
    INTENTION_SELECT = 5,
    /**
     * INTENTION_ESCAPE
     *
     * @syscap SystemCapability.MultimodalInput.Input.Core
     * @since 10
     */
    /**
     * INTENTION_ESCAPE
     *
     * @syscap SystemCapability.MultimodalInput.Input.Core
     * @atomicservice
     * @since 12
     */
    INTENTION_ESCAPE = 6,
    /**
     * INTENTION_BACK
     *
     * @syscap SystemCapability.MultimodalInput.Input.Core
     * @since 10
     */
    /**
     * INTENTION_BACK
     *
     * @syscap SystemCapability.MultimodalInput.Input.Core
     * @atomicservice
     * @since 12
     */
    INTENTION_BACK = 7,
    /**
     * INTENTION_FORWARD
     *
     * @syscap SystemCapability.MultimodalInput.Input.Core
     * @since 10
     */
    /**
     * INTENTION_FORWARD
     *
     * @syscap SystemCapability.MultimodalInput.Input.Core
     * @atomicservice
     * @since 12
     */
    INTENTION_FORWARD = 8,
    /**
     * INTENTION_MENU
     *
     * @syscap SystemCapability.MultimodalInput.Input.Core
     * @since 10
     */
    /**
     * INTENTION_MENU
     *
     * @syscap SystemCapability.MultimodalInput.Input.Core
     * @atomicservice
     * @since 12
     */
    INTENTION_MENU = 9,
    /**
     * INTENTION_PAGE_UP
     *
     * @syscap SystemCapability.MultimodalInput.Input.Core
     * @since 10
     */
    /**
     * INTENTION_PAGE_UP
     *
     * @syscap SystemCapability.MultimodalInput.Input.Core
     * @atomicservice
     * @since 12
     */
    INTENTION_PAGE_UP = 11,
    /**
     * INTENTION_PAGE_DOWN
     *
     * @syscap SystemCapability.MultimodalInput.Input.Core
     * @since 10
     */
    /**
     * INTENTION_PAGE_DOWN
     *
     * @syscap SystemCapability.MultimodalInput.Input.Core
     * @atomicservice
     * @since 12
     */
    INTENTION_PAGE_DOWN = 12,
    /**
     * INTENTION_ZOOM_OUT
     *
     * @syscap SystemCapability.MultimodalInput.Input.Core
     * @since 10
     */
    /**
     * INTENTION_ZOOM_OUT
     *
     * @syscap SystemCapability.MultimodalInput.Input.Core
     * @atomicservice
     * @since 12
     */
    INTENTION_ZOOM_OUT = 13,
    /**
     * INTENTION_ZOOM_IN
     *
     * @syscap SystemCapability.MultimodalInput.Input.Core
     * @since 10
     */
    /**
     * INTENTION_ZOOM_IN
     *
     * @syscap SystemCapability.MultimodalInput.Input.Core
     * @atomicservice
     * @since 12
     */
    INTENTION_ZOOM_IN = 14
}
