import type { UTSOutputOptions } from '@dcloudio/uts';
import { type RunKotlinBuildResult, type RunKotlinDevResult } from '../kotlin';
type UniCloudObjectInfo = {
    name: string;
    methodList: string[];
};
export interface CompileAppOptions {
    inputDir: string;
    outputDir: string;
    outFilename?: string;
    package: string;
    sourceMap: boolean;
    uni_modules: string[];
    pages: string[];
    extApis?: Record<string, [string, string]>;
    split?: boolean;
    disableSplitManifest?: boolean;
    uniCloudObjectInfo?: Array<UniCloudObjectInfo>;
    pageCount: number;
    extApiComponents: string[];
    uvueClassNamePrefix?: string;
    autoImports?: Record<string, [string, string?][]>;
    extApiProviders?: [string, string, string][];
    uniModulesArtifacts?: {
        name: string;
        package: string;
        scopedSlots: string[];
        declaration: string;
    }[];
    env?: Record<string, unknown>;
    transform?: UTSOutputOptions['transform'];
}
export declare function compileApp(entry: string, options: CompileAppOptions): Promise<RunKotlinBuildResult | RunKotlinDevResult | undefined>;
export declare function uvueOutDir(platform: 'app-android' | 'app-ios' | 'app-harmony'): string;
export declare function tscOutDir(platform: 'app-android' | 'app-ios' | 'app-harmony'): string;
export declare function kotlinSrcDir(kotlinDir: string): string;
export {};
