"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getPluginInjectApis = exports.addPluginInjectApis = exports.updateManifestModulesByCloud = exports.isEnableInlineReified = exports.isEnableGenericsParameterDefaults = exports.isEnableSplitClass = exports.isNormalCompileTarget = exports.normalizeUTSResult = exports.resolveUVueFileName = exports.resolveBundleInputFileName = exports.resolveBundleInputRoot = exports.requireUniHelpers = exports.formatUniProviderName = exports.resolveConfigProvider = exports.normalizeExtApiModules = exports.parseExtApiProviders = exports.parseExtApiModules = exports.parseInjectModules = exports.normalizeExtApiDefaultParameters = exports.parseExtApiDefaultParameters = exports.shouldAutoImportUniCloud = exports.isUniCloudSupported = exports.resolveUniAppXSourceMapFile = exports.resolveUniAppXSourceMapPath = exports.resolveSourceMapFile = exports.relative = exports.isColorSupported = exports.parseSwiftPackageWithPluginId = exports.parseKotlinPackageWithPluginId = exports.genConfigJson = exports.genComponentsCode = exports.resolveIOSComponents = exports.resolveAndroidComponents = exports.resolveCustomElements = exports.isCustomElementsSupported = exports.getCompilerServer = exports.createResolveTypeReferenceName = exports.resolveUTSPlatformFile = exports.resolveIOSDir = exports.resolveAndroidDir = exports.isRootIndex = exports.moveRootIndexSourceMap = exports.genUTSPlatformResource = exports.copyPlatformFiles = exports.copyPlatformNativeLanguageFiles = exports.resolvePackage = exports.getUTSCompiler = exports.resolveUTSSourceMapPath = exports.SPECIAL_CHARS = exports.ERR_MSG_PLACEHOLDER = void 0;
exports.getPluginInjectComponents = exports.getPluginInjectCustomElements = exports.addPluginInjectCustomElements = exports.addPluginInjectComponents = void 0;
const path_1 = __importStar(require("path"));
const fs_extra_1 = __importDefault(require("fs-extra"));
const shared_1 = require("@vue/shared");
const fast_glob_1 = __importStar(require("fast-glob"));
const shared_2 = require("./shared");
const uvue_1 = require("./uvue");
exports.ERR_MSG_PLACEHOLDER = `___ERR_MSG___`;
exports.SPECIAL_CHARS = {
    WARN_BLOCK: '\uFEFF', // 警告块前后标识
    ERROR_BLOCK: '\u2060', // 错误块前后标识
};
function resolveUTSSourceMapPath() {
    return (0, shared_2.resolveSourceMapPath)();
}
exports.resolveUTSSourceMapPath = resolveUTSSourceMapPath;
function getUTSCompiler() {
    // eslint-disable-next-line no-restricted-globals
    return require('@dcloudio/uts');
}
exports.getUTSCompiler = getUTSCompiler;
function findLastIndex(array, predicate) {
    for (let i = array.length - 1; i >= 0; i--) {
        if (predicate(array[i], i, array)) {
            return i;
        }
    }
    return -1;
}
function resolvePackage(filename) {
    const parts = (0, shared_2.normalizePath)(filename).split('/');
    const isUniModules = parts.includes('uni_modules');
    const index = isUniModules
        ? findLastIndex(parts, (part) => part === 'uni_modules')
        : findLastIndex(parts, (part) => part === 'utssdk');
    if (index > -1) {
        const id = parts[index + 1];
        const name = (0, shared_1.camelize)(prefix(id));
        return {
            id,
            name,
            namespace: 'UTSSDK' + (isUniModules ? 'Modules' : '') + (0, shared_1.capitalize)(name),
            is_uni_modules: isUniModules,
            extname: '.uts',
        };
    }
}
exports.resolvePackage = resolvePackage;
const GARBAGE_REGEX = /(?:Thumbs\.db|\.DS_Store)$/i;
const isGarbageFile = (file) => GARBAGE_REGEX.test(file);
// 删除所有空子目录，需要考虑到.DS_Store等文件
function removeAllEmptySubDir(dir) {
    if (!fs_extra_1.default.existsSync(dir)) {
        return;
    }
    try {
        const files = fs_extra_1.default.readdirSync(dir);
        for (const file of files) {
            const filePath = path_1.default.join(dir, file);
            const stat = fs_extra_1.default.statSync(filePath);
            if (stat.isDirectory()) {
                removeAllEmptySubDir(filePath);
                const subFiles = fs_extra_1.default.readdirSync(filePath);
                if (subFiles.length === 0 || subFiles.every(isGarbageFile)) {
                    fs_extra_1.default.rmSync(filePath, { recursive: true, force: true });
                }
            }
        }
    }
    catch { }
}
function copyPlatformNativeLanguageFiles(utsInputDir, utsOutputDir, extnameArr, transform) {
    const srcFiles = [];
    const destFiles = [];
    if (fs_extra_1.default.existsSync(utsInputDir)) {
        // 遍历所有的 extname 文件，并进行 rewrite
        const globPattern = extnameArr.length > 1
            ? `**/*.{${extnameArr.map((extname) => extname.slice(1)).join(',')}}`
            : `**/*${extnameArr[0]}`;
        (0, fast_glob_1.sync)(globPattern, {
            cwd: utsInputDir,
            absolute: false,
        }).forEach((file) => {
            const srcFile = path_1.default.resolve(utsInputDir, file);
            const destFile = path_1.default.resolve(utsOutputDir, file);
            const content = fs_extra_1.default.readFileSync(srcFile, 'utf8');
            const newContent = transform ? transform(srcFile, content) : content;
            fs_extra_1.default.outputFileSync(destFile, newContent);
            srcFiles.push(srcFile);
            destFiles.push(destFile);
        });
    }
    return { srcFiles, destFiles };
}
exports.copyPlatformNativeLanguageFiles = copyPlatformNativeLanguageFiles;
function copyPlatformFiles(utsInputDir, utsOutputDir, extnameArr) {
    const files = [];
    if (fs_extra_1.default.existsSync(utsInputDir)) {
        fs_extra_1.default.copySync(utsInputDir, utsOutputDir, {
            filter(src) {
                if (fs_extra_1.default.statSync(src).isDirectory()) {
                    return true;
                }
                if (extnameArr.includes(path_1.default.extname(src))) {
                    // 应该引入copy后的文件
                    files.push(src);
                    return true;
                }
                return false;
            },
        });
    }
    return files;
}
exports.copyPlatformFiles = copyPlatformFiles;
function genUTSPlatformResource(filename, options) {
    const platformFile = resolveUTSPlatformFile(filename, options);
    const { platform } = options;
    const utsInputDir = resolveUTSPlatformDir(filename, platform);
    const utsOutputDir = resolveUTSPlatformDir(platformFile, platform);
    const extname = options.extname === '.kt' ? ['.kt', '.java'] : [options.extname];
    const configJsonFile = (0, shared_2.normalizePath)(path_1.default.resolve(utsInputDir, 'config.json'));
    // 拷贝所有非uts,vue文件及目录
    if (fs_extra_1.default.existsSync(utsInputDir)) {
        fs_extra_1.default.copySync(utsInputDir, utsOutputDir, {
            filter(src) {
                // ignore config.json
                if ((0, shared_2.normalizePath)(src) === configJsonFile) {
                    return false;
                }
                if (extname.includes(path_1.default.extname(src))) {
                    return false;
                }
                return !['.uts', '.vue'].includes(path_1.default.extname(src));
            },
        });
    }
    if (options.uniModules && options.uniModules.length) {
        const pkgJsonFile = path_1.default.resolve(options.inputDir, 'uni_modules', options.pluginId, 'package.json');
        if (fs_extra_1.default.existsSync(pkgJsonFile)) {
            fs_extra_1.default.copyFileSync(pkgJsonFile, path_1.default.resolve(options.outputDir, 'uni_modules', options.pluginId, 'package.json'));
        }
    }
    copyConfigJson(platform, options.isX, utsInputDir, utsOutputDir, options.hookClass, options.components, options.customElements, options.package, options.provider);
    // 生产模式下，需要将生成的平台文件转移到 src 下
    const srcDir = path_1.default.resolve(utsOutputDir, 'src');
    if (!fs_extra_1.default.existsSync(srcDir)) {
        fs_extra_1.default.mkdirSync(srcDir, { recursive: true });
    }
    if (fs_extra_1.default.existsSync(platformFile)) {
        fs_extra_1.default.moveSync(platformFile, path_1.default.resolve(utsOutputDir, 'src/index' + options.extname), {
            overwrite: true,
        });
        copyPlatformFiles(utsInputDir, path_1.default.join(utsOutputDir, 'src'), extname);
    }
    if (options.result.chunks) {
        options.result.chunks.forEach((chunk) => {
            const chunkFile = path_1.default.resolve(utsOutputDir, chunk);
            if (fs_extra_1.default.existsSync(chunkFile)) {
                fs_extra_1.default.moveSync(chunkFile, path_1.default.resolve(utsOutputDir, 'src', chunk), {
                    overwrite: true,
                });
            }
        });
    }
    removeAllEmptySubDir(utsOutputDir);
}
exports.genUTSPlatformResource = genUTSPlatformResource;
function moveRootIndexSourceMap(filename, { inputDir, platform, extname, }) {
    if (isRootIndex(filename, platform)) {
        const sourceMapFilename = path_1.default
            .resolve(resolveUTSSourceMapPath(), path_1.default.relative(inputDir, filename))
            .replace(path_1.default.extname(filename), extname + '.map');
        if (fs_extra_1.default.existsSync(sourceMapFilename)) {
            const newSourceMapFilename = path_1.default.resolve(path_1.default.dirname(sourceMapFilename), platform, path_1.default.basename(sourceMapFilename));
            fs_extra_1.default.moveSync(sourceMapFilename, newSourceMapFilename, {
                overwrite: true,
            });
        }
    }
}
exports.moveRootIndexSourceMap = moveRootIndexSourceMap;
function isRootIndex(filename, platform) {
    return path_1.default.basename(path_1.default.dirname(filename)) !== platform;
}
exports.isRootIndex = isRootIndex;
function resolveAndroidDir(filename) {
    return resolveUTSPlatformDir(filename, 'app-android');
}
exports.resolveAndroidDir = resolveAndroidDir;
function resolveIOSDir(filename) {
    return resolveUTSPlatformDir(filename, 'app-ios');
}
exports.resolveIOSDir = resolveIOSDir;
function resolveUTSPlatformDir(filename, platform) {
    const maybePlatformDir = path_1.default.dirname(filename);
    if (isRootIndex(filename, platform)) {
        return path_1.default.join(maybePlatformDir, platform);
    }
    return maybePlatformDir;
}
function resolveUTSPlatformFile(filename, { inputDir, outputDir, platform, extname, }) {
    let platformFile = path_1.default
        .resolve(outputDir, path_1.default.relative(inputDir, filename))
        .replace(path_1.default.extname(filename), extname);
    // 如果是根目录的 index.uts 编译出来的 index.kt，则移动到平台目录下
    if (isRootIndex(filename, platform)) {
        if (fs_extra_1.default.existsSync(platformFile)) {
            const newPlatformFile = path_1.default.resolve(path_1.default.dirname(platformFile), platform + '/index' + extname);
            fs_extra_1.default.moveSync(platformFile, newPlatformFile, {
                overwrite: true,
            });
            platformFile = newPlatformFile;
        }
    }
    return platformFile;
}
exports.resolveUTSPlatformFile = resolveUTSPlatformFile;
function resolveTypeAliasDeclNames(items) {
    const names = [];
    items.forEach((item) => {
        if (item.type === 'TsTypeAliasDeclaration') {
            names.push(item.id.value);
        }
        else if (item.type === 'ExportDeclaration' &&
            item.declaration.type === 'TsTypeAliasDeclaration') {
            names.push(item.declaration.id.value);
        }
    });
    return names;
}
function createResolveTypeReferenceName(namespace, ast, interfaceTypes) {
    const names = resolveTypeAliasDeclNames(ast.body);
    return (name) => {
        if (names.includes(name) || (0, shared_1.hasOwn)(interfaceTypes, name)) {
            return namespace + (0, shared_1.capitalize)(name) + 'JSONObject';
        }
        return name;
    };
}
exports.createResolveTypeReferenceName = createResolveTypeReferenceName;
function getCompilerServer(pluginName) {
    if (!process.env.UNI_HBUILDERX_PLUGINS) {
        console.error(`该项目必须在 HBuilderX 中运行`);
        return;
    }
    const isAndroid = pluginName === 'uniapp-runextension';
    const compilerServerPath = path_1.default.resolve(process.env.UNI_HBUILDERX_PLUGINS, `${pluginName}/out/${isAndroid ? 'main.js' : 'external.js'}`);
    const installed = isAndroid
        ? fs_extra_1.default.existsSync(compilerServerPath) &&
            fs_extra_1.default.existsSync(path_1.default.resolve(process.env.UNI_HBUILDERX_PLUGINS, `uts-development-android/out/external.js`))
        : fs_extra_1.default.existsSync(compilerServerPath);
    if (installed) {
        // eslint-disable-next-line no-restricted-globals
        return require(compilerServerPath);
    }
    else {
        if ((0, shared_2.runByHBuilderX)()) {
            (0, shared_2.installHBuilderXPlugin)(isAndroid ? 'uts-development-android' : pluginName);
        }
        else {
            console.error(compilerServerPath + ' is not found');
        }
    }
}
exports.getCompilerServer = getCompilerServer;
function resolveComponents(platform, pluginDir, is_uni_modules) {
    const components = {};
    const platformDir = path_1.default.resolve(pluginDir, is_uni_modules ? 'utssdk' : '', platform);
    if (fs_extra_1.default.existsSync(platformDir)) {
        fast_glob_1.default
            .sync('**/*.vue', { cwd: platformDir, absolute: true })
            .forEach((file) => {
            let name = parseVueComponentName(file);
            if (!name) {
                if (file.endsWith('index.vue')) {
                    name = path_1.default.basename(pluginDir);
                }
            }
            if (name && !components[name]) {
                components[name] = file;
            }
        });
    }
    return components;
}
function isCustomElementsSupported(pluginDir) {
    if (process.env.UNI_UTS_PLATFORM) {
        // 当前平台不支持自定义元素
        const packageJson = path_1.default.resolve(pluginDir, 'package.json');
        if (fs_extra_1.default.existsSync(packageJson)) {
            const pkg = (0, shared_2.parseJson)(fs_extra_1.default.readFileSync(packageJson, 'utf8'));
            const customElements = pkg['uni_modules']?.['customElements'];
            if (customElements &&
                typeof customElements === 'object' &&
                customElements[process.env.UNI_UTS_PLATFORM] === false) {
                return false;
            }
        }
    }
    return true;
}
exports.isCustomElementsSupported = isCustomElementsSupported;
function resolveCustomElements(pluginDir) {
    if (!isCustomElementsSupported(pluginDir)) {
        return {};
    }
    const customElements = {};
    const customElementsDir = path_1.default.resolve(pluginDir, 'customElements');
    if (fs_extra_1.default.existsSync(customElementsDir)) {
        const ext = '.uts';
        fs_extra_1.default.readdirSync(customElementsDir).forEach((name) => {
            if (!customElements[name]) {
                const folder = path_1.default.resolve(customElementsDir, name);
                if (!isDir(folder)) {
                    return;
                }
                const files = fs_extra_1.default.readdirSync(folder);
                // 读取文件夹文件列表，比对文件名（fs.existsSync在大小写不敏感的系统会匹配不准确）
                if (files.includes(name + ext)) {
                    customElements[name] = path_1.default.resolve(folder, name + ext);
                }
            }
        });
    }
    return customElements;
}
exports.resolveCustomElements = resolveCustomElements;
const isDir = (path) => {
    const stat = fs_extra_1.default.lstatSync(path);
    if (stat.isDirectory()) {
        return true;
    }
    else if (stat.isSymbolicLink()) {
        return fs_extra_1.default.lstatSync(fs_extra_1.default.realpathSync(path)).isDirectory();
    }
    return false;
};
function resolveAndroidComponents(pluginDir, is_uni_modules) {
    return resolveComponents('app-android', pluginDir, is_uni_modules);
}
exports.resolveAndroidComponents = resolveAndroidComponents;
function resolveIOSComponents(pluginDir, is_uni_modules) {
    return resolveComponents('app-ios', pluginDir, is_uni_modules);
}
exports.resolveIOSComponents = resolveIOSComponents;
const nameRE = /export\s+default\s+[\s\S]*?name\s*:\s*['|"](.*?)['|"]/;
function parseVueComponentName(file) {
    const content = fs_extra_1.default.readFileSync(file, 'utf8');
    const matches = content.match(nameRE);
    if (matches) {
        return matches[1];
    }
}
function genComponentsCode(filename, components, isX) {
    const codes = [];
    const dirname = path_1.default.dirname(filename);
    Object.keys(components).forEach((name) => {
        const source = (0, shared_2.normalizePath)(path_1.default.relative(dirname, components[name]));
        const className = (0, shared_1.capitalize)((0, shared_1.camelize)(name));
        codes.push(`export { default as ${className}Component${isX
            ? `, ${process.env.UNI_UTS_MODULE_PREFIX ? 'Uni' : className}Element`
            : ''} } from '${source.startsWith('.') ? source : './' + source}'`);
    });
    return codes.join('\n');
}
exports.genComponentsCode = genComponentsCode;
function genConfigJson(platform, isX, hookClass, components, customElements, pluginRelativeDir, is_uni_modules, inputDir, outputDir, provider) {
    // 不过滤了，只要有，就copy
    // if (!Object.keys(components).length && !hookClass && !provider) {
    //   return
    // }
    const pluginId = (0, path_1.basename)(pluginRelativeDir);
    const utsInputDir = (0, path_1.resolve)(inputDir, pluginRelativeDir, is_uni_modules ? 'utssdk' : '', platform);
    const utsOutputDir = (0, path_1.resolve)(outputDir, pluginRelativeDir, is_uni_modules ? 'utssdk' : '', platform);
    copyConfigJson(platform, isX, utsInputDir, utsOutputDir, hookClass, components, customElements, platform === 'app-android'
        ? parseKotlinPackageWithPluginId(pluginId, is_uni_modules) + '.'
        : parseSwiftPackageWithPluginId(pluginId, is_uni_modules), provider);
}
exports.genConfigJson = genConfigJson;
function copyConfigJson(platform, isX, inputDir, outputDir, hookClass, componentsObj, customElementsObj, namespace, provider) {
    const configJsonFilename = (0, path_1.resolve)(inputDir, 'config.json');
    const outputConfigJsonFilename = (0, path_1.resolve)(outputDir, 'config.json');
    const hasComponents = !!Object.keys(componentsObj).length;
    const hasCustomElements = customElementsObj && !!Object.keys(customElementsObj).length;
    const hasHookClass = !!hookClass;
    const hasProvider = !!provider;
    if (hasComponents || hasCustomElements || hasHookClass || hasProvider) {
        const configJson = fs_extra_1.default.existsSync(configJsonFilename)
            ? (0, shared_2.parseJson)(fs_extra_1.default.readFileSync(configJsonFilename, 'utf8'))
            : {};
        //存在组件
        if (hasComponents) {
            configJson.components = genComponentsConfigJson(platform, isX, componentsObj, namespace);
        }
        if (hasCustomElements) {
            function addCustomElements(key) {
                if (!configJson[key]) {
                    configJson[key] = [];
                }
                genCustomElementsConfigJson(platform, isX, customElementsObj, namespace).forEach((item) => {
                    const name = item.name.replace('uni-', '');
                    // customElement优先级高于组件
                    const index = configJson[key].findIndex((component) => component.name === item.name);
                    if (index > -1) {
                        configJson[key].splice(index, 1);
                    }
                    configJson[key].push({
                        type: 'customElement',
                        ...item,
                        name,
                    });
                });
            }
            addCustomElements(platform === 'app-android' ? 'easycom' : 'components');
        }
        if (hasHookClass) {
            configJson.hooksClass = hookClass;
        }
        if (hasProvider) {
            configJson.provider = provider;
        }
        fs_extra_1.default.outputFileSync(outputConfigJsonFilename, JSON.stringify(configJson, null, 2));
    }
    else {
        if (fs_extra_1.default.existsSync(configJsonFilename)) {
            fs_extra_1.default.copySync(configJsonFilename, outputConfigJsonFilename);
        }
    }
}
function genComponentsConfigJson(platform, isX, components, namespace) {
    const res = [];
    Object.keys(components).forEach((name) => {
        const normalized = (0, shared_1.capitalize)((0, shared_1.camelize)(name));
        const options = {
            name,
            class: namespace + normalized + 'Component',
        };
        if (isX && platform === 'app-ios') {
            options['delegateClass'] = normalized + 'ComponentRegister';
        }
        res.push(options);
    });
    return res;
}
function genCustomElementsConfigJson(platform, isX, customElements, namespace) {
    const res = [];
    Object.keys(customElements).forEach((name) => {
        const normalized = (0, shared_1.capitalize)((0, shared_1.camelize)(name));
        const options = {
            name,
            class: namespace + normalized + 'Element',
        };
        if (isX) {
            if (platform === 'app-ios') {
                options['delegateClass'] = normalized + 'ElementRegister';
            }
            else {
                options.class = options.class + 'Register';
                options.method = 'register';
            }
        }
        res.push(options);
    });
    return res;
}
function prefix(id) {
    if (process.env.UNI_UTS_MODULE_PREFIX &&
        !id.startsWith(process.env.UNI_UTS_MODULE_PREFIX)) {
        return process.env.UNI_UTS_MODULE_PREFIX + '-' + id;
    }
    return id;
}
function parseKotlinPackageWithPluginId(id, is_uni_modules) {
    return 'uts.sdk.' + (is_uni_modules ? 'modules.' : '') + (0, shared_1.camelize)(prefix(id));
}
exports.parseKotlinPackageWithPluginId = parseKotlinPackageWithPluginId;
function parseSwiftPackageWithPluginId(id, is_uni_modules) {
    return ('UTSSDK' +
        (is_uni_modules ? 'Modules' : '') +
        (0, shared_1.capitalize)((0, shared_1.camelize)(prefix(id))));
}
exports.parseSwiftPackageWithPluginId = parseSwiftPackageWithPluginId;
function isColorSupported() {
    if ('NO_COLOR' in process.env || (0, shared_2.isInHBuilderX)()) {
        return false;
    }
    return true;
}
exports.isColorSupported = isColorSupported;
function relative(filename, inputDir) {
    if (path_1.default.isAbsolute(filename)) {
        return (0, shared_2.normalizePath)(path_1.default.relative(inputDir, filename));
    }
    return filename;
}
exports.relative = relative;
function resolveSourceMapFile(outputDir, kotlinFile) {
    return (path_1.default.resolve((0, shared_2.resolveSourceMapPath)(), path_1.default.relative(outputDir, kotlinFile)) +
        '.map');
}
exports.resolveSourceMapFile = resolveSourceMapFile;
function resolveUniAppXSourceMapPath(tempRootDir) {
    return path_1.default.resolve(tempRootDir, 'sourcemap');
}
exports.resolveUniAppXSourceMapPath = resolveUniAppXSourceMapPath;
function resolveUniAppXSourceMapFile(tempRootDir, outputDir, kotlinFile) {
    return (path_1.default.resolve(resolveUniAppXSourceMapPath(tempRootDir), path_1.default.relative(outputDir, kotlinFile)) + '.map');
}
exports.resolveUniAppXSourceMapFile = resolveUniAppXSourceMapFile;
function isUniCloudSupported() {
    if (!process.env.UNI_CLOUD_SPACES) {
        return false;
    }
    try {
        const spaces = JSON.parse(process.env.UNI_CLOUD_SPACES);
        if (Array.isArray(spaces) && spaces.length > 0) {
            return true;
        }
        return false;
    }
    catch (e) {
        return false;
    }
}
exports.isUniCloudSupported = isUniCloudSupported;
// 是否应自动引入uniCloud模块
function shouldAutoImportUniCloud() {
    return (isUniCloudSupported() ||
        process.env.UNI_APP_X_UNICLOUD_OBJECT === 'true' ||
        process.env.NODE_ENV !== 'production');
}
exports.shouldAutoImportUniCloud = shouldAutoImportUniCloud;
function parseExtApiDefaultParameters() {
    return normalizeExtApiDefaultParameters(require('../lib/ext-api/default-parameters.json'));
}
exports.parseExtApiDefaultParameters = parseExtApiDefaultParameters;
function normalizeExtApiDefaultParameters(json) {
    const res = {};
    Object.keys(json).forEach((key) => {
        const module = json[key];
        Object.keys(module).forEach((api) => {
            const value = module[api];
            if ((0, shared_1.isArray)(value)) {
                const newValue = value.map((v) => v ?? '');
                res[api] = newValue;
            }
            else {
                res[api] = [value];
            }
        });
    });
    return res;
}
exports.normalizeExtApiDefaultParameters = normalizeExtApiDefaultParameters;
function parseInjectModules(inject_apis, localExtApis, extApiComponents) {
    const modules = new Set();
    const extApiModules = parseExtApiModules();
    inject_apis.forEach((api) => {
        if (api.startsWith('uniCloud.')) {
            modules.add('uni-cloud-client');
        }
        else {
            if (extApiModules[api] &&
                // 非本地
                !(0, shared_1.hasOwn)(localExtApis, api.replace('uni.', ''))) {
                modules.add(extApiModules[api]);
            }
        }
    });
    extApiComponents.forEach((component) => {
        const name = 'component.' + component;
        if (extApiModules[name]) {
            modules.add(extApiModules[name]);
        }
    });
    return [...modules];
}
exports.parseInjectModules = parseInjectModules;
function readExtApiModulesJson() {
    const json = require('../lib/ext-api/modules.json');
    if (!json['uni-canvas']) {
        json['uni-canvas'] = {};
    }
    json['uni-canvas']['components'] = ['canvas'];
    const isXHarmony = process.env.UNi_APP_X === 'true' &&
        process.env.UNI_UTS_PLATFORM === 'app-harmony';
    if (isXHarmony) {
        let modules = JSON.parse(JSON.stringify(json)); // 拷贝一份操作
        const harmonyModules = Object.keys(require('../lib/arkts/external-module-exports-x.json'));
        for (const key in modules) {
            if (!harmonyModules.includes('@uni_modules/' + key.toLowerCase())) {
                delete modules[key];
            }
        }
        return modules;
    }
    return json;
}
function parseExtApiModules() {
    return normalizeExtApiModules(readExtApiModulesJson());
}
exports.parseExtApiModules = parseExtApiModules;
function parseExtApiProviders() {
    const modules = readExtApiModulesJson();
    const providers = {};
    const moduleNames = Object.keys(modules);
    // 第一遍，先遍历出来所有的service
    moduleNames.forEach((name) => {
        const module = modules[name];
        const providerOptions = module.provider;
        if (providerOptions?.service && !providerOptions?.name) {
            providers[name] = {
                service: providerOptions.service,
                providers: [],
            };
        }
    });
    // 第二遍，遍历所有provider
    moduleNames.forEach((name) => {
        const module = modules[name];
        const providerOptions = module.provider;
        if (providerOptions?.name && providerOptions?.service) {
            const moduleName = Object.keys(providers).find((moduleName) => providers[moduleName].service === providerOptions.service);
            if (moduleName) {
                providers[moduleName].providers.push(providerOptions.name);
            }
        }
    });
    return providers;
}
exports.parseExtApiProviders = parseExtApiProviders;
function normalizeExtApiModules(json) {
    const res = {};
    Object.keys(json).forEach((module) => {
        const options = json[module];
        if ((0, shared_1.isPlainObject)(options)) {
            if (options.uni) {
                const uniApis = options.uni;
                if ((0, shared_1.isString)(uniApis)) {
                    res['uni.' + uniApis] = module;
                }
                else if ((0, shared_1.isArray)(uniApis)) {
                    uniApis.forEach((api) => {
                        res['uni.' + api] = module;
                    });
                }
                else if ((0, shared_1.isPlainObject)(uniApis)) {
                    Object.keys(uniApis).forEach((api) => {
                        res['uni.' + api] = module;
                    });
                }
            }
            if ((0, shared_1.isArray)(options.components)) {
                options.components.forEach((component) => {
                    res['component.' + component] = module;
                });
            }
            if ((0, shared_1.isArray)(options.easycom)) {
                options.easycom.forEach((component) => {
                    res['component.' + component] = module;
                });
            }
        }
    });
    return res;
}
exports.normalizeExtApiModules = normalizeExtApiModules;
function resolveConfigProvider(platform, plugin, transform) {
    if (transform?.uniExtApiProviderName && transform?.uniExtApiProviderService) {
        return {
            name: transform.uniExtApiProviderName,
            service: transform.uniExtApiProviderService,
            class: (platform === 'app-android'
                ? parseKotlinPackageWithPluginId(plugin, true) + '.'
                : parseSwiftPackageWithPluginId(plugin, true)) +
                formatExtApiProviderName(transform.uniExtApiProviderService, transform.uniExtApiProviderName),
        };
    }
}
exports.resolveConfigProvider = resolveConfigProvider;
function formatUniProviderName(service) {
    if (service === 'oauth') {
        service = 'OAuth';
    }
    return `Uni${(0, shared_1.capitalize)((0, shared_1.camelize)(service))}Provider`;
}
exports.formatUniProviderName = formatUniProviderName;
function formatExtApiProviderName(service, name) {
    if (service === 'oauth') {
        service = 'OAuth';
    }
    return `Uni${(0, shared_1.capitalize)((0, shared_1.camelize)(service))}${(0, shared_1.capitalize)((0, shared_1.camelize)(name))}ProviderImpl`;
}
function requireUniHelpers() {
    require(path_1.default.resolve(process.env.UNI_HBUILDERX_PLUGINS, 'uni_helpers/lib/bytenode'));
    return require(path_1.default.join(process.env.UNI_HBUILDERX_PLUGINS, 'uni_helpers'));
}
exports.requireUniHelpers = requireUniHelpers;
function resolveBundleInputRoot(platform, root) {
    if (process.env.UNI_APP_X_TSC === 'true' &&
        // 云端uni_modules编译，传入的已经是真实地址
        (isNormalCompileTarget() || process.env.UNI_COMPILE_TARGET === 'ext-api')) {
        return (0, uvue_1.uvueOutDir)(platform);
    }
    return root;
}
exports.resolveBundleInputRoot = resolveBundleInputRoot;
function resolveBundleInputFileName(platform, fileName) {
    if (process.env.UNI_APP_X_TSC === 'true' &&
        // 云端uni_modules编译，传入的已经是真实地址 uni-cli-shared/vite/cloud.ts:190
        (isNormalCompileTarget() || process.env.UNI_COMPILE_TARGET === 'ext-api')) {
        const uvueDir = (0, shared_2.normalizePath)((0, uvue_1.uvueOutDir)(platform));
        if (!fileName.startsWith(uvueDir)) {
            return (0, shared_2.normalizePath)(path_1.default.resolve(uvueDir, path_1.default.relative(process.env.UNI_INPUT_DIR, fileName)));
        }
    }
    return fileName;
}
exports.resolveBundleInputFileName = resolveBundleInputFileName;
function resolveUVueFileName(platform, fileName) {
    if (!fileName) {
        return fileName;
    }
    if (process.env.UNI_APP_X_TSC === 'true') {
        const inputDir = (0, shared_2.normalizePath)(process.env.UNI_INPUT_DIR);
        fileName = (0, shared_2.normalizePath)(fileName);
        if (fileName.startsWith(inputDir)) {
            return (0, shared_2.normalizePath)(path_1.default.resolve((0, uvue_1.uvueOutDir)(platform), path_1.default.relative(inputDir, fileName)));
        }
    }
    return fileName;
}
exports.resolveUVueFileName = resolveUVueFileName;
function normalizeUTSResult(platform, result) {
    if (process.env.UNI_APP_X_TSC === 'true') {
        if (result.deps && result.deps.length) {
            const uvueDir = (0, shared_2.normalizePath)((0, uvue_1.uvueOutDir)(platform));
            result.deps = result.deps.map((file) => {
                file = (0, shared_2.normalizePath)(file);
                if (file.startsWith(uvueDir)) {
                    return path_1.default.resolve(process.env.UNI_INPUT_DIR, path_1.default.relative(uvueDir, file));
                }
                return file;
            });
        }
    }
    return result;
}
exports.normalizeUTSResult = normalizeUTSResult;
function isNormalCompileTarget() {
    // 目前有特殊编译目标 uni_modules 和 ext-api
    return !process.env.UNI_COMPILE_TARGET;
}
exports.isNormalCompileTarget = isNormalCompileTarget;
let utsConfig;
function getUTSConfig() {
    if (!utsConfig) {
        if (process.env.UNI_INPUT_DIR) {
            const configPath = path_1.default.resolve(process.env.UNI_INPUT_DIR, 'uts.config.json');
            if (fs_extra_1.default.existsSync(configPath)) {
                utsConfig = require(configPath);
            }
        }
        if (!utsConfig) {
            utsConfig = {};
        }
    }
    return utsConfig;
}
function isEnableUTSFeature(feature) {
    return getUTSConfig()[feature];
}
function isEnableSplitClass() {
    return isEnableUTSFeature('splitClass');
}
exports.isEnableSplitClass = isEnableSplitClass;
function isEnableGenericsParameterDefaults() {
    return isEnableUTSFeature('enableGenericsParameterDefaults');
}
exports.isEnableGenericsParameterDefaults = isEnableGenericsParameterDefaults;
function isEnableInlineReified() {
    return isEnableUTSFeature('enableInlineReified');
}
exports.isEnableInlineReified = isEnableInlineReified;
function updateManifestModulesByCloud(platform, inputDir, inject_apis, localExtApis = {}) {
    const filename = path_1.default.resolve(inputDir, 'manifest.json');
    if (fs_extra_1.default.existsSync(filename)) {
        const content = fs_extra_1.default.readFileSync(filename, 'utf8');
        try {
            const json = JSON.parse(content);
            if (!json[platform]) {
                json[platform] = {};
                if (json.app?.distribute?.modules) {
                    json[platform].distribute = {
                        modules: JSON.parse(JSON.stringify(json.app.distribute.modules)),
                    };
                }
            }
            if (!json[platform].distribute) {
                json[platform].distribute = {};
            }
            if (!json[platform].distribute.modules) {
                json[platform].distribute.modules = {};
            }
            const modules = json[platform].distribute.modules;
            let updated = false;
            parseInjectModules(inject_apis, localExtApis, []).forEach((name) => {
                if (!(0, shared_1.hasOwn)(modules, name)) {
                    modules[name] = {};
                    updated = true;
                }
            });
            if (updated) {
                fs_extra_1.default.outputFileSync(filename, JSON.stringify(json, null, 2));
            }
        }
        catch (e) { }
    }
}
exports.updateManifestModulesByCloud = updateManifestModulesByCloud;
const pluginInjectApis = new Set();
function addPluginInjectApis(apis) {
    apis.forEach((api) => {
        pluginInjectApis.add(api);
    });
}
exports.addPluginInjectApis = addPluginInjectApis;
function getPluginInjectApis() {
    return [...pluginInjectApis];
}
exports.getPluginInjectApis = getPluginInjectApis;
const pluginInjectComponents = new Set();
function addPluginInjectComponents(components) {
    components.forEach((component) => {
        pluginInjectComponents.add(component);
    });
}
exports.addPluginInjectComponents = addPluginInjectComponents;
const pluginInjectCustomElements = {};
function addPluginInjectCustomElements(customElements) {
    Object.keys(customElements).forEach((key) => {
        pluginInjectCustomElements[key] = customElements[key];
    });
}
exports.addPluginInjectCustomElements = addPluginInjectCustomElements;
function getPluginInjectCustomElements() {
    return pluginInjectCustomElements;
}
exports.getPluginInjectCustomElements = getPluginInjectCustomElements;
function getPluginInjectComponents() {
    return [...pluginInjectComponents];
}
exports.getPluginInjectComponents = getPluginInjectComponents;
