import type { UTSOutputOptions, UTSResult, UTSTarget, bundle, parse } from '@dcloudio/uts';
import type { Module } from '../types/types';
import type { ClassMeta } from './code';
type UTSPluginPlatform = 'app-android' | 'app-ios' | 'app-harmony';
interface ToOptions {
    inputDir: string;
    outputDir: string;
    outFilename?: string;
    sourceMap: boolean;
    components: Record<string, string>;
    customElements?: Record<string, string>;
    isX: boolean;
    isSingleThread: boolean;
    isPlugin: boolean;
    isExtApi?: boolean;
    isModule?: boolean;
    extApis?: Record<string, [string, string]>;
    transform?: UTSOutputOptions['transform'];
    uniModules: string[];
}
export type ToKotlinOptions = ToOptions;
export type ToSwiftOptions = ToOptions;
export declare const ERR_MSG_PLACEHOLDER = "___ERR_MSG___";
export declare const SPECIAL_CHARS: {
    WARN_BLOCK: string;
    ERROR_BLOCK: string;
};
export interface RunOptions {
    components: Record<string, string>;
    customElements?: Record<string, string>;
    extApis?: Record<string, [string, string]>;
    isPlugin: boolean;
    isSingleThread: boolean;
    isX: boolean;
    isExtApi?: boolean;
    sourceMap: boolean;
    transform?: UTSOutputOptions['transform'];
    uniModules: string[];
}
export interface RunProdOptions extends RunOptions {
    isModule?: boolean;
    hookClass: string;
    uniModuleId: string;
    outFilename?: string;
}
export interface RunDevOptions extends RunOptions {
    cacheDir: string;
    pluginRelativeDir: string;
    is_uni_modules: boolean;
    rewriteConsoleExpr?: (fileName: string, content: string) => string;
}
export declare function resolveUTSSourceMapPath(): string;
export declare function getUTSCompiler(): {
    parse: typeof parse;
    bundle: typeof bundle;
    UTSTarget: typeof UTSTarget;
};
export declare function resolvePackage(filename: string): {
    id: string;
    name: string;
    namespace: string;
    is_uni_modules: boolean;
    extname: string;
} | undefined;
export declare function copyPlatformNativeLanguageFiles(utsInputDir: string, utsOutputDir: string, extnameArr: string[], transform?: (fileName: string, content: string) => string): {
    srcFiles: string[];
    destFiles: string[];
};
export declare function copyPlatformFiles(utsInputDir: string, utsOutputDir: string, extnameArr: string[]): string[];
export interface UTSPlatformResourceOptions {
    isX: boolean;
    pluginId: string;
    inputDir: string;
    outputDir: string;
    platform: typeof process.env.UNI_UTS_PLATFORM;
    extname: '.kt' | '.swift';
    components: Record<string, string>;
    customElements?: Record<string, string>;
    package: string;
    hookClass: string;
    result: UTSResult;
    provider?: {
        name: string;
        service: string;
        class: string;
    };
    uniModules: string[];
}
export declare function genUTSPlatformResource(filename: string, options: UTSPlatformResourceOptions): void;
export declare function moveRootIndexSourceMap(filename: string, { inputDir, platform, extname, }: Omit<UTSPlatformResourceOptions, 'hookClass' | 'pluginId' | 'uniModules' | 'components' | 'customElements'>): void;
export declare function isRootIndex(filename: string, platform: typeof process.env.UNI_UTS_PLATFORM): boolean;
export declare function resolveAndroidDir(filename: string): string;
export declare function resolveIOSDir(filename: string): string;
export declare function resolveUTSPlatformFile(filename: string, { inputDir, outputDir, platform, extname, }: Omit<UTSPlatformResourceOptions, 'hookClass' | 'pluginId' | 'uniModules' | 'components' | 'customElements'>): string;
export declare function createResolveTypeReferenceName(namespace: string, ast: Module, interfaceTypes: Record<string, ClassMeta>): (name: string) => string;
export type CompilerServer = {};
export declare function getCompilerServer<T extends CompilerServer>(pluginName: 'uts-development-ios' | 'uniapp-runextension'): T | undefined;
export declare function isCustomElementsSupported(pluginDir: string): boolean;
export declare function resolveCustomElements(pluginDir: string): Record<string, string>;
export declare function resolveAndroidComponents(pluginDir: string, is_uni_modules: boolean): Record<string, string>;
export declare function resolveIOSComponents(pluginDir: string, is_uni_modules: boolean): Record<string, string>;
export declare function genComponentsCode(filename: string, components: Record<string, string>, isX: boolean): string;
export declare function genConfigJson(platform: 'app-android' | 'app-ios', isX: boolean, hookClass: string, components: Record<string, string>, customElements: Record<string, string> | undefined, pluginRelativeDir: string, is_uni_modules: boolean, inputDir: string, outputDir: string, provider?: {
    name: string;
    service: string;
    class: string;
}): void;
export declare function parseKotlinPackageWithPluginId(id: string, is_uni_modules: boolean): string;
export declare function parseSwiftPackageWithPluginId(id: string, is_uni_modules: boolean): string;
export declare function isColorSupported(): boolean;
export declare function relative(filename: string, inputDir: string): string;
export declare function resolveSourceMapFile(outputDir: string, kotlinFile: string): string;
export declare function resolveUniAppXSourceMapPath(tempRootDir: string): string;
export declare function resolveUniAppXSourceMapFile(tempRootDir: string, outputDir: string, kotlinFile: string): string;
export declare function isUniCloudSupported(): boolean;
export declare function shouldAutoImportUniCloud(): boolean;
export declare function parseExtApiDefaultParameters(): Record<string, string[]>;
export declare function normalizeExtApiDefaultParameters(json: Record<string, any>): Record<string, string[]>;
export declare function parseInjectModules(inject_apis: string[], localExtApis: Record<string, [string, string]>, extApiComponents: string[]): string[];
export declare function parseExtApiModules(): Record<string, string>;
export declare function parseExtApiProviders(): {
    [name: string]: {
        service: string;
        providers: string[];
    };
};
export type DefineOptions = {
    name?: string;
    app?: boolean | {
        js?: boolean;
        kotlin?: boolean;
        swift?: boolean;
    };
    [key: string]: any;
};
export type Define = string | string[] | Record<string, string | DefineOptions> | false;
export declare function normalizeExtApiModules(json: Record<string, any>): Record<string, string>;
export declare function resolveConfigProvider(platform: 'app-android' | 'app-ios', plugin: string, transform: UTSOutputOptions['transform']): {
    name: string;
    service: string;
    class: string;
} | undefined;
export declare function formatUniProviderName(service: string): string;
export declare function requireUniHelpers(): any;
export declare function resolveBundleInputRoot(platform: UTSPluginPlatform, root: string): string;
export declare function resolveBundleInputFileName(platform: UTSPluginPlatform, fileName: string): string;
export declare function resolveUVueFileName(platform: 'app-android' | 'app-ios', fileName: string): string;
export declare function normalizeUTSResult(platform: UTSPluginPlatform, result: UTSResult): UTSResult;
export declare function isNormalCompileTarget(): boolean;
export declare function isEnableSplitClass(): boolean | undefined;
export declare function isEnableGenericsParameterDefaults(): boolean | undefined;
export declare function isEnableInlineReified(): boolean | undefined;
export declare function updateManifestModulesByCloud(platform: 'app-android' | 'app-ios', inputDir: string, inject_apis: string[], localExtApis?: Record<string, [string, string]>): void;
export declare function addPluginInjectApis(apis: string[]): void;
export declare function getPluginInjectApis(): string[];
export declare function addPluginInjectComponents(components: string[]): void;
export declare function addPluginInjectCustomElements(customElements: Record<string, string>): void;
export declare function getPluginInjectCustomElements(): Record<string, string>;
export declare function getPluginInjectComponents(): string[];
export {};
