import { type UniXCompiler } from './tsc/compiler';
export declare function createUniXArkTSCompiler(): UniXCompiler;
export declare const createUniXArkTSCompilerOnce: typeof createUniXArkTSCompiler;
export declare function createUniXKotlinCompiler(): UniXCompiler;
export declare const createUniXKotlinCompilerOnce: typeof createUniXKotlinCompiler;
export declare function createUniXSwiftCompiler(): UniXCompiler;
export declare const createUniXSwiftCompilerOnce: typeof createUniXSwiftCompiler;
export type UniXCompilerPlatform = 'app-android' | 'app-ios' | 'app-harmony';
export declare function compileUniModuleWithTsc(platform: UniXCompilerPlatform, pluginDir: string, uniXCompiler: UniXCompiler, { rootFiles, preprocessor, }: {
    rootFiles?: string[] | ((platform: UniXCompilerPlatform) => string[]);
    preprocessor: SyncUniModulesFilePreprocessor;
}): Promise<void>;
export declare function syncUniModuleFilesByCompiler(platform: UniXCompilerPlatform, compiler: UniXCompiler, pluginDir: string, preprocessor: SyncUniModulesFilePreprocessor): Promise<void>;
export type SyncUniModulesFilePreprocessor = (code: string, fileName: string) => Promise<string>;
export declare function resolveOutputPluginDir(platform: UniXCompilerPlatform, inputDir: string, pluginDir: string): string;
export declare function resolveUVueOutputPluginDir(platform: UniXCompilerPlatform, inputDir: string, pluginDir: string): string;
export declare function resolveTscUniModuleIndexFileName(platform: UniXCompilerPlatform, pluginDir: string): string | undefined;
