"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.checkIOSVersionTips = exports.resolveIOSDepFiles = exports.compile = exports.runSwiftDev = exports.runSwiftProd = void 0;
const fs_extra_1 = __importDefault(require("fs-extra"));
const path_1 = __importStar(require("path"));
const utils_1 = require("./utils");
const shared_1 = require("./shared");
const stacktrace_1 = require("./stacktrace");
function parseSwiftPackage(filename) {
    const res = (0, utils_1.resolvePackage)(filename);
    if (!res) {
        return {
            id: '',
            namespace: '',
        };
    }
    const namespace = (0, utils_1.parseSwiftPackageWithPluginId)(res.name, res.is_uni_modules);
    return {
        id: res.id,
        namespace,
    };
}
async function runSwiftProd(filename, { components, customElements, uniModuleId, isPlugin, isModule, isX, isSingleThread, isExtApi, extApis, transform, sourceMap, hookClass, uniModules, }) {
    // 文件有可能是 app-android 里边的，因为编译到 ios 时，为了保证不报错，可能会去读取 android 下的 uts
    if (filename.includes('app-android')) {
        return;
    }
    const inputDir = process.env.UNI_INPUT_DIR;
    const outputDir = process.env.UNI_OUTPUT_DIR;
    const result = await compile(filename, {
        inputDir,
        outputDir,
        sourceMap: !!sourceMap,
        components,
        customElements,
        isX,
        isSingleThread,
        isPlugin,
        isExtApi,
        extApis,
        transform,
        uniModules,
    });
    if (!result) {
        return;
    }
    if (result.error) {
        throw (0, stacktrace_1.parseUTSSyntaxError)(result.error, inputDir);
    }
    const autoImportUniCloud = (0, utils_1.shouldAutoImportUniCloud)();
    const useUniCloudApi = result.inject_apis &&
        result.inject_apis.find((api) => api.startsWith('uniCloud.'));
    if (autoImportUniCloud && !useUniCloudApi) {
        result.inject_apis = result.inject_apis || [];
        result.inject_apis.push('uniCloud.importObject');
    }
    if (result.inject_apis && result.inject_apis.length) {
        if (isModule) {
            // noop
        }
        else if (isX && process.env.UNI_UTS_COMPILER_TYPE === 'cloud') {
            (0, utils_1.updateManifestModulesByCloud)('app-ios', inputDir, result.inject_apis, extApis);
        }
        else {
            (0, utils_1.addPluginInjectApis)(result.inject_apis);
        }
    }
    (0, utils_1.genUTSPlatformResource)(filename, {
        isX,
        pluginId: uniModuleId,
        inputDir,
        outputDir,
        platform: 'app-ios',
        extname: '.swift',
        components,
        customElements,
        package: parseSwiftPackage(filename).namespace,
        hookClass,
        result,
        provider: (0, utils_1.resolveConfigProvider)('app-ios', uniModuleId, transform),
        uniModules,
    });
}
exports.runSwiftProd = runSwiftProd;
let isEnvReady = true;
async function runSwiftDev(filename, { components, customElements, isX, isSingleThread, isPlugin, isExtApi, extApis, transform, sourceMap, uniModules, rewriteConsoleExpr, }) {
    // 文件有可能是 app-android 里边的，因为编译到 ios 时，为了保证不报错，可能会去读取 android 下的 uts
    if (filename.includes('app-android')) {
        return;
    }
    if (!isEnvReady) {
        console.error(`已跳过uts插件[${(0, utils_1.resolvePackage)(filename)?.id}]的编译`);
        return;
    }
    const compilerServer = (0, utils_1.getCompilerServer)('uts-development-ios');
    if (!compilerServer) {
        throw new Error(`项目使用了uts插件，正在安装 uts iOS 运行扩展...`);
    }
    if (compilerServer.checkEnv) {
        const { code, msg } = compilerServer.checkEnv();
        if (code) {
            isEnvReady = false;
            console.error(msg);
            return;
        }
    }
    const inputDir = process.env.UNI_INPUT_DIR;
    const outputDir = process.env.UNI_OUTPUT_DIR;
    const result = (await compile(filename, {
        inputDir,
        outputDir,
        sourceMap: !!sourceMap,
        components,
        customElements,
        isX,
        isSingleThread,
        isPlugin,
        isExtApi,
        extApis,
        transform,
        uniModules,
    }));
    if (!result) {
        return;
    }
    if (result.error) {
        throw (0, stacktrace_1.parseUTSSyntaxError)(result.error, inputDir);
    }
    result.type = 'swift';
    const swiftFile = (0, utils_1.resolveUTSPlatformFile)(filename, {
        isX,
        inputDir,
        outputDir,
        platform: 'app-ios',
        extname: '.swift',
        package: '',
        result,
    });
    result.changed = [];
    // 开发模式下，需要生成 framework
    if (fs_extra_1.default.existsSync(swiftFile)) {
        let projectPath = inputDir;
        const isCli = isCliProject(projectPath);
        if (isCli) {
            projectPath = path_1.default.resolve(projectPath, '..');
        }
        const { id, is_uni_modules } = (0, utils_1.resolvePackage)(filename);
        const { srcFiles } = (0, utils_1.copyPlatformNativeLanguageFiles)(path_1.default.resolve(inputDir, 'uni_modules', id, 'utssdk', 'app-ios'), path_1.default.resolve(outputDir, 'uni_modules', id, 'utssdk', 'app-ios'), ['.swift'], (fileName, content) => {
            if (!isX) {
                // 非 x 平台，需要替换所有 DCloudUniappRuntime 导入为 DCloudUTSFoundation
                content = content.replace(/DCloudUniappRuntime/g, 'DCloudUTSFoundation');
            }
            return rewriteConsoleExpr
                ? rewriteConsoleExpr(fileName, content)
                : content;
        });
        const { code, msg } = await compilerServer.compile({
            projectPath,
            isCli,
            type: is_uni_modules ? 1 : 2,
            pluginName: id,
            utsPath: resolveCompilerUTSPath(inputDir, is_uni_modules),
            swiftPath: resolveCompilerSwiftPath(outputDir, is_uni_modules),
        });
        result.deps = [...(result.deps || []), ...srcFiles];
        result.code = code;
        result.msg = msg;
        result.changed = [swiftFile];
    }
    return result;
}
exports.runSwiftDev = runSwiftDev;
function resolveCompilerUTSPath(projectPath, is_uni_modules) {
    return path_1.default.resolve(projectPath, is_uni_modules ? 'uni_modules' : 'utssdk');
}
function resolveCompilerSwiftPath(outputDir, is_uni_modules) {
    return path_1.default.resolve(outputDir, is_uni_modules ? 'uni_modules' : 'utssdk');
}
function isCliProject(projectPath) {
    if (projectPath.endsWith('src')) {
        return true;
    }
    return false;
}
async function compile(filename, { inputDir, outputDir, sourceMap, components, customElements, isX, isSingleThread, isPlugin, isExtApi, extApis, transform, uniModules, }) {
    const { bundle, UTSTarget } = (0, utils_1.getUTSCompiler)();
    // let time = Date.now()
    const componentsCode = (0, utils_1.genComponentsCode)(filename, components, isX);
    const { namespace, id: pluginId } = parseSwiftPackage(filename);
    const input = {
        root: (0, utils_1.resolveBundleInputRoot)('app-ios', inputDir),
        filename: (0, utils_1.resolveBundleInputFileName)('app-ios', filename),
        pluginId,
        paths: {},
        uniModules,
        uniModulesPrefix: process.env.UNI_UTS_MODULE_PREFIX || '',
    };
    // 必须判断input.filename，因为input.filename可能跟filename不一样（可能会变成.uvue目录的文件）
    const isUTSFileExists = fs_extra_1.default.existsSync(input.filename);
    if (componentsCode) {
        if (!isUTSFileExists) {
            input.fileContent = componentsCode;
        }
        else {
            input.fileContent =
                fs_extra_1.default.readFileSync(input.filename, 'utf8') + `\n` + componentsCode;
        }
    }
    else {
        // uts文件不存在，且也无组件
        if (!isUTSFileExists) {
            return;
        }
    }
    const options = {
        mode: process.env.NODE_ENV,
        hbxVersion: process.env.HX_Version || process.env.UNI_COMPILER_VERSION,
        input,
        output: {
            isX,
            isSingleThread,
            isPlugin,
            isExtApi,
            outDir: outputDir,
            package: namespace,
            sourceMap: sourceMap ? (0, utils_1.resolveUTSSourceMapPath)() : false,
            extname: 'swift',
            imports: [
                ...(transform?.uniExtApiProviderName ? ['DCloudUTSExtAPI'] : []),
                'DCloudUTSFoundation',
                ...(isX ? ['DCloudUniappRuntime'] : []),
            ],
            logFilename: true,
            noColor: !(0, utils_1.isColorSupported)(),
            transform: {
                uniExtApiDefaultNamespace: 'DCloudUTSExtAPI',
                uniExtApiNamespaces: extApis,
                uniExtApiDefaultParameters: (0, utils_1.parseExtApiDefaultParameters)(),
                ...transform,
            },
        },
    };
    const result = await bundle(UTSTarget.SWIFT, options);
    sourceMap &&
        (0, utils_1.moveRootIndexSourceMap)(filename, {
            isX,
            inputDir,
            outputDir,
            platform: 'app-ios',
            extname: '.swift',
            package: '',
            result,
        });
    return (0, utils_1.normalizeUTSResult)('app-ios', result);
}
exports.compile = compile;
const deps = ['Info.plist', 'config.json'];
function resolveIOSDepFiles(filename) {
    const dir = (0, utils_1.resolveIOSDir)(filename);
    return deps.map((dep) => path_1.default.resolve(dir, dep));
}
exports.resolveIOSDepFiles = resolveIOSDepFiles;
function checkIOSVersionTips(pluginId, pluginDir, is_uni_modules) {
    const configJsonFile = (0, path_1.join)(pluginDir, is_uni_modules ? 'utssdk' : '', 'app-ios', 'config.json');
    if (configJsonFile && fs_extra_1.default.existsSync(configJsonFile)) {
        try {
            const configJson = (0, shared_1.parseJson)(fs_extra_1.default.readFileSync(configJsonFile, 'utf8'));
            if (configJson.deploymentTarget &&
                parseFloat(configJson.deploymentTarget) > 12) {
                return `uts插件[${pluginId}]需在 iOS ${configJson.deploymentTarget} 版本及以上方可正常使用`;
            }
        }
        catch (e) { }
    }
}
exports.checkIOSVersionTips = checkIOSVersionTips;
