"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseRelativeSourceFile = exports.generateCodeFrame = exports.lineColumnToStartEnd = exports.resolveSourceMapFileBySourceFile = exports.resolveSourceMapDirByCacheDir = exports.splitRE = exports.COLORS = void 0;
const fs_1 = __importDefault(require("fs"));
const path_1 = __importStar(require("path"));
const shared_1 = require("../shared");
exports.COLORS = {
    warn: '\u200B',
    error: '\u200C',
};
exports.splitRE = /\r?\n/;
function resolveSourceMapDirByCacheDir(cacheDir) {
    return path_1.default.resolve(cacheDir, 'sourcemap');
}
exports.resolveSourceMapDirByCacheDir = resolveSourceMapDirByCacheDir;
function resolveSourceMapFileBySourceFile(file, sourceMapDir) {
    const sourceMapFile = path_1.default.resolve(sourceMapDir, file + '.map');
    if (fs_1.default.existsSync(sourceMapFile)) {
        return sourceMapFile;
    }
}
exports.resolveSourceMapFileBySourceFile = resolveSourceMapFileBySourceFile;
const range = 2;
function posToNumber(source, pos) {
    if (typeof pos === 'number')
        return pos;
    const lines = source.split(exports.splitRE);
    const { line, column } = pos;
    let start = 0;
    for (let i = 0; i < line - 1; i++) {
        start += lines[i].length + 1;
    }
    return start + column;
}
function lineColumnToStartEnd(source, line, column) {
    const lines = source.split(exports.splitRE);
    let start = 0;
    for (let i = 0; i < line - 1; i++) {
        start += lines[i].length + 1;
    }
    return {
        start: start + column,
        end: start + lines[line - 1].length,
    };
}
exports.lineColumnToStartEnd = lineColumnToStartEnd;
function generateCodeFrame(source, start = 0, end) {
    start = posToNumber(source, start);
    end = end || start;
    const lines = source.split(exports.splitRE);
    let count = 0;
    const res = [];
    for (let i = 0; i < lines.length; i++) {
        count += lines[i].length + 1;
        if (count >= start) {
            for (let j = i - range; j <= i + range || end > count; j++) {
                if (j < 0 || j >= lines.length)
                    continue;
                const line = j + 1;
                res.push(`${line}${' '.repeat(Math.max(3 - String(line).length, 0))}|  ${lines[j]}`);
                const lineLength = lines[j].length;
                if (j === i) {
                    // push underline
                    const pad = start - (count - lineLength) + 1;
                    const length = Math.max(1, end > count ? lineLength - pad : end - start);
                    res.push(`   |  ` + ' '.repeat(pad) + '^'.repeat(length));
                }
                else if (j > i) {
                    if (end > count) {
                        const length = Math.max(Math.min(end - count, lineLength), 1);
                        res.push(`   |  ` + '^'.repeat(length));
                    }
                    count += lineLength + 1;
                }
            }
            break;
        }
    }
    return res.join('\n');
}
exports.generateCodeFrame = generateCodeFrame;
function parseRelativeSourceFile(sourceFile, sourceRoot) {
    if (!sourceRoot) {
        return sourceFile;
    }
    sourceFile = (0, shared_1.normalizePath)(sourceFile);
    sourceRoot = (0, shared_1.normalizePath)(sourceRoot);
    if (sourceFile.startsWith(sourceRoot)) {
        return (0, shared_1.normalizePath)((0, path_1.relative)(sourceRoot, sourceFile));
    }
    return sourceFile;
}
exports.parseRelativeSourceFile = parseRelativeSourceFile;
