import { type GenerateRuntimeCodeFrameOptions } from './utils';
export interface MessageSourceLocation {
    type: 'exception' | 'error' | 'warning' | 'info' | 'logging' | 'output';
    message: string;
    file?: string;
    line?: number;
    column?: number;
    code?: string;
}
interface GenerateCodeFrameOptions {
    inputDir: string;
    sourceMapDir: string;
    replaceTabsWithSpace?: boolean;
    format: (msg: MessageSourceLocation) => string;
}
export declare function hbuilderFormatter(m: MessageSourceLocation): string;
export declare function parseUTSKotlinStacktrace(messages: MessageSourceLocation[], options: GenerateCodeFrameOptions): Promise<string>;
export interface KotlinManifestCache {
    version: string;
    env: Record<string, string>;
    files: Record<string, Record<string, string>>;
}
export declare function updateUTSKotlinSourceMapManifestCache(cacheDir: string): void;
export declare function parseFilenameByClassName(className: string): string;
export interface GenerateKotlinRuntimeCodeFrameOptions extends GenerateRuntimeCodeFrameOptions {
    appid: string;
    language: 'kotlin';
}
export interface GenerateAppAndroidKotlinRuntimeCodeFrameOptions extends GenerateKotlinRuntimeCodeFrameOptions {
    platform: 'app-android';
}
export declare function resolveUTSKotlinFilenameByClassName(className: string, { cacheDir }: {
    cacheDir: string;
}): string;
export declare function parseUTSKotlinRuntimeStacktrace(stacktrace: string, options: GenerateKotlinRuntimeCodeFrameOptions): string;
export {};
