"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseUTSSyntaxError = exports.parseUTSRuntimeStacktrace = exports.parseRuntimeStacktrace = exports.parseUTSJavaScriptRuntimeStacktrace = exports.resolveUTSKotlinFilenameByClassName = exports.parseUTSKotlinRuntimeStacktrace = exports.parseUTSKotlinStacktrace = exports.parseUTSArkTSPluginStacktrace = exports.parseUTSSwiftPluginStacktrace = void 0;
const utils_1 = require("../utils");
const arkts_1 = require("./arkts");
const js_1 = require("./js");
const kotlin_1 = require("./kotlin");
const mp_1 = require("./mp");
var swift_1 = require("./swift");
Object.defineProperty(exports, "parseUTSSwiftPluginStacktrace", { enumerable: true, get: function () { return swift_1.parseUTSSwiftPluginStacktrace; } });
var arkts_2 = require("./arkts");
Object.defineProperty(exports, "parseUTSArkTSPluginStacktrace", { enumerable: true, get: function () { return arkts_2.parseUTSArkTSPluginStacktrace; } });
var kotlin_2 = require("./kotlin");
Object.defineProperty(exports, "parseUTSKotlinStacktrace", { enumerable: true, get: function () { return kotlin_2.parseUTSKotlinStacktrace; } });
Object.defineProperty(exports, "parseUTSKotlinRuntimeStacktrace", { enumerable: true, get: function () { return kotlin_2.parseUTSKotlinRuntimeStacktrace; } });
Object.defineProperty(exports, "resolveUTSKotlinFilenameByClassName", { enumerable: true, get: function () { return kotlin_2.resolveUTSKotlinFilenameByClassName; } });
var js_2 = require("./js");
Object.defineProperty(exports, "parseUTSJavaScriptRuntimeStacktrace", { enumerable: true, get: function () { return js_2.parseUTSJavaScriptRuntimeStacktrace; } });
async function parseRuntimeStacktrace(stacktrace, options) {
    if ((options.platform === 'app-android' && options.language === 'kotlin') ||
        (options.platform === 'app-ios' && options.language === 'javascript') ||
        options.platform === 'app-harmony') {
        return parseUTSRuntimeStacktrace(stacktrace, options);
    }
    // mp-weixin:   sourceMap可以合并映射（所以开发工具可以显示源码） 可以读取到sourceMap（下载js文件，解析里边的base64格式sourceMap）
    // mp-baidu:    sourceMap无法合并映射（所以开发工具无法显示源码） 可以读取到sourceMap 二次解析映射（也可以合并sourceMap吧）
    // mp-toutiao:  sourceMap可以合并映射（所以开发工具可以显示源码） 可以读取到sourceMap（下载js文件，解析里边的base64格式sourceMap）
    // mp-alipay:   sourceMap可以合并映射（所以开发工具可以显示源码） 可以读取到sourceMap（下载js文件，解析url格式的sourceMap，再根据url下载sourceMap）
    if (mp_1.MP_PLATFORMS[options.platform]) {
        return (0, mp_1.parseMiniProgramRuntimeStacktrace)(stacktrace, options);
    }
    // 其他小程序平台暂不处理，因为没法拿到小程序的sourceMap做合并映射
    return stacktrace;
}
exports.parseRuntimeStacktrace = parseRuntimeStacktrace;
function parseUTSRuntimeStacktrace(stacktrace, options) {
    if (options.platform === 'app-harmony') {
        return (0, arkts_1.parseUTSHarmonyRuntimeStacktrace)(stacktrace, options);
    }
    else if (options.language === 'kotlin') {
        return (0, kotlin_1.parseUTSKotlinRuntimeStacktrace)(stacktrace, options);
    }
    else if (options.language === 'javascript') {
        return (0, js_1.parseUTSJavaScriptRuntimeStacktrace)(stacktrace, options);
    }
}
exports.parseUTSRuntimeStacktrace = parseUTSRuntimeStacktrace;
function parseUTSSyntaxError(error, inputDir) {
    let errorMsg = error;
    if (error instanceof Error) {
        errorMsg = error.message;
    }
    let msg = String(errorMsg).replace(/\t/g, ' ');
    let res = null;
    const syntaxErrorRe = /(,-\[(.*):(\d+):(\d+)\])/g;
    let matched = false;
    while ((res = syntaxErrorRe.exec(msg))) {
        const [row, filename, line, column] = res.slice(1);
        msg = msg.replace(row, `at ${(0, utils_1.relative)(filename.split('?')[0], inputDir)}:${parseInt(line) + 3}:${column}`);
        matched = true;
    }
    if (!matched) {
        return error;
    }
    return msg;
}
exports.parseUTSSyntaxError = parseUTSSyntaxError;
