import { type GenerateRuntimeCodeFrameOptions } from './utils';
import { type GenerateAppHarmonyJavaScriptRuntimeCodeFrameOptions } from './js';
export interface ParseUTSArkTSPluginStacktraceOptions {
    /**
     * 项目输入目录 = process.env.UNI_INPUT_DIR
     */
    inputDir: string;
    /**
     * 项目输出目录 = process.env.UNI_OUTPUT_DIR
     */
    outputDir: string;
}
/**
 * 解析uts插件编译时的ArkTS的堆栈信息
 */
export declare function parseUTSArkTSPluginStacktrace(stacktrace: string, options: ParseUTSArkTSPluginStacktraceOptions): Promise<string>;
export type GenerateAppHarmonyCodeFrameOptions = GenerateAppHarmonyArkTSRuntimeCodeFrameOptions | GenerateAppHarmonyJavaScriptRuntimeCodeFrameOptions | GenerateAppHarmonyAutoCodeFrameOptions;
export interface GenerateAppHarmonyAutoCodeFrameOptions extends GenerateRuntimeCodeFrameOptions, ParseUTSArkTSPluginStacktraceOptions {
    platform: 'app-harmony';
}
export interface GenerateAppHarmonyArkTSRuntimeCodeFrameOptions extends GenerateAppHarmonyAutoCodeFrameOptions, ParseUTSArkTSPluginStacktraceOptions {
    platform: 'app-harmony';
    language: 'arkts';
}
export declare function parseUTSHarmonyRuntimeStacktrace(stacktrace: string, options: GenerateAppHarmonyCodeFrameOptions): string | Promise<string>;
export declare function parseUTSArkTSRuntimeStacktrace(stacktrace: string, options: GenerateAppHarmonyArkTSRuntimeCodeFrameOptions): Promise<string>;
