import type { UTSResult } from '@dcloudio/uts';
import { type CompilerServer, type RunDevOptions, type RunOptions, type RunProdOptions, type ToKotlinOptions } from './utils';
import type { Module } from '../types/types';
import type { APP_PLATFORM } from './manifest/utils';
import { type MessageSourceLocation } from './stacktrace/kotlin';
export interface KotlinCompilerServer extends CompilerServer {
    getKotlincHome(): string;
    getDefaultJar(arg?: any): string[];
    getCompilerJar?: (userJars: string[], version?: number) => string[];
    compile(options: {
        kotlinc: string[];
        d8: string[];
        stderrListener: (data: string) => void;
        pageCount: number;
    }, projectPath: string): Promise<{
        code: number;
        msg: string;
        data?: {
            dexList: string[];
        };
    }>;
    checkDependencies?: (configJsonPath: string, options?: {
        type: 1 | 2;
        valid: boolean;
    }) => Promise<{
        code: number;
        msg: string;
        data: string[];
    }>;
    checkRResources?: (resDir: string) => Promise<{
        code: number;
        msg: string;
        data: {
            jarPath: string;
            uniModuleName: string;
        };
    }>;
}
export declare function createKotlinResolveTypeReferenceName(_namespace: string, _ast: Module): (name: string) => string;
export declare function runKotlinProd(filename: string, { outFilename, components, customElements, uniModuleId, isPlugin, isModule, isX, isSingleThread, isExtApi, hookClass, extApis, transform, sourceMap, uniModules, }: RunProdOptions): Promise<UTSResult | undefined>;
export type RunKotlinDevResult = UTSResult & {
    type: 'kotlin';
    changed: string[];
    inject_modules: string[];
    kotlinc: boolean;
    kotlincJars?: string[];
    code: number;
    msg: string;
};
export type RunKotlinBuildResult = UTSResult & {
    type: 'kotlin';
    inject_modules: string[];
    kotlinc: false;
};
export interface RunKotlinProdOptions extends RunOptions {
    hookClass: string;
    pluginId: string;
}
export interface RunKotlinDevOptions extends RunOptions {
    components: Record<string, string>;
    cacheDir: string;
    pluginRelativeDir: string;
    is_uni_modules: boolean;
}
export declare function runKotlinDev(filename: string, { components, customElements, isX, isSingleThread, isPlugin, isExtApi, cacheDir, pluginRelativeDir, is_uni_modules, extApis, transform, sourceMap, uniModules, rewriteConsoleExpr, }: RunDevOptions): Promise<RunKotlinDevResult | undefined>;
export declare function compileAndroidDex(isX: boolean, compilerServer: KotlinCompilerServer, kotlinFiles: string[], jarFile: string, sourceMapPath: string, depJars: string[], stderrListener: (data: string) => void): Promise<{
    code: number;
    msg: string;
    data?: {
        dexList: string[];
    } | undefined;
}>;
export declare function hasDeps(configJsonFile: string): boolean;
export declare function resolveAndroidDepFiles(filename: string): string[];
export declare function compile(filename: string, { inputDir, outputDir, sourceMap, components, customElements, isX, isSingleThread, isPlugin, isModule, isExtApi, extApis, transform, uniModules, outFilename, }: ToKotlinOptions): Promise<UTSResult | undefined>;
export declare function resolveKotlincArgs(files: string[], dest: string, kotlinc: string, jars: string[]): string[];
export declare const D8_DEFAULT_ARGS: string[];
export declare function resolveD8Args(filename: string): string[];
export declare function resolveAndroidArchiveOutputPath(aar: string): string;
export declare function resolveDexFile(jarFile: string): string;
export declare function resolveJarPath(platform: APP_PLATFORM, cacheDir: string, pluginRelativeDir: string, filename: string): string;
export declare function checkAndroidVersionTips(pluginId: string, pluginDir: string, is_uni_modules: boolean): string | undefined;
export declare function getUniModulesEncryptCacheJars(cacheDir: string, plugins?: string[]): string[];
export declare function getUniModulesCacheJars(cacheDir: string, plugins?: string[]): string[];
export declare function getUniModulesJars(outputDir: string, plugins?: string[]): string[];
export declare function createStderrListener(inputDir: string, sourceMapDir: string, waiting: {
    done: Promise<void> | undefined;
}, format: (msg: MessageSourceLocation) => string): (data: any) => Promise<void>;
export declare function kotlinDir(_outputDir: string): string;
export declare function parseUTSModuleLibsJars(plugins: string[]): string[];
export declare function parseUTSModuleConfigJsonJars(checkType: 1 | 2, plugins: string[], checkDependencies: Required<KotlinCompilerServer>['checkDependencies'], checkDependenciesValid: boolean, checkError: (plugin: string) => void): Promise<string[]>;
