"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.buildUniModules = exports.initCompilerOptionsTransform = exports.compile = exports.toSwift = exports.toKotlin = exports.resolveUTSKotlinFilenameByClassName = exports.parseUTSArkTSPluginStacktrace = exports.parseUTSJavaScriptRuntimeStacktrace = exports.parseUTSKotlinRuntimeStacktrace = exports.parseUTSRuntimeStacktrace = exports.parseRuntimeStacktrace = exports.parseExtApiProviders = exports.parseInjectModules = exports.compileApp = exports.sourcemap = exports.resolveAppHarmonyUniModulesEntryDir = exports.resolveAppHarmonyUniModulesRootDir = exports.getArkTSAutoImports = exports.compileArkTSExtApi = exports.compileArkTS = exports.parseInterfaceTypes = exports.parseExportIdentifiers = exports.getPluginInjectComponents = exports.getPluginInjectApis = void 0;
const shared_1 = require("@vue/shared");
const path_1 = require("path");
const kotlin_1 = require("./kotlin");
const swift_1 = require("./swift");
const code_1 = require("./code");
const utils_1 = require("./utils");
const stacktrace_1 = require("./stacktrace");
const sourceMap_1 = require("./sourceMap");
const shared_2 = require("./shared");
const legacy_1 = require("./legacy");
const manifest_1 = require("./manifest");
const utils_2 = require("./manifest/utils");
const encrypt_1 = require("./encrypt");
const module_1 = require("./module");
const compiler_1 = require("./compiler");
const index_1 = require("./uvue/index");
const uni_modules_1 = require("./uni_modules");
const fs_extra_1 = require("fs-extra");
const dex_1 = require("./manifest/dex");
const arkts_1 = require("./arkts");
__exportStar(require("./tsc"), exports);
var utils_3 = require("./utils");
Object.defineProperty(exports, "getPluginInjectApis", { enumerable: true, get: function () { return utils_3.getPluginInjectApis; } });
Object.defineProperty(exports, "getPluginInjectComponents", { enumerable: true, get: function () { return utils_3.getPluginInjectComponents; } });
var code_2 = require("./code");
Object.defineProperty(exports, "parseExportIdentifiers", { enumerable: true, get: function () { return code_2.parseExportIdentifiers; } });
Object.defineProperty(exports, "parseInterfaceTypes", { enumerable: true, get: function () { return code_2.parseInterfaceTypes; } });
var arkts_2 = require("./arkts");
Object.defineProperty(exports, "compileArkTS", { enumerable: true, get: function () { return arkts_2.compileArkTS; } });
Object.defineProperty(exports, "compileArkTSExtApi", { enumerable: true, get: function () { return arkts_2.compileArkTSExtApi; } });
Object.defineProperty(exports, "getArkTSAutoImports", { enumerable: true, get: function () { return arkts_2.getArkTSAutoImports; } });
Object.defineProperty(exports, "resolveAppHarmonyUniModulesRootDir", { enumerable: true, get: function () { return arkts_2.resolveAppHarmonyUniModulesRootDir; } });
Object.defineProperty(exports, "resolveAppHarmonyUniModulesEntryDir", { enumerable: true, get: function () { return arkts_2.resolveAppHarmonyUniModulesEntryDir; } });
exports.sourcemap = {
    generateCodeFrameWithKotlinStacktrace: legacy_1.generateCodeFrameWithKotlinStacktrace,
    generateCodeFrameWithSwiftStacktrace: legacy_1.generateCodeFrameWithSwiftStacktrace,
};
var index_2 = require("./uvue/index");
Object.defineProperty(exports, "compileApp", { enumerable: true, get: function () { return index_2.compileApp; } });
var utils_4 = require("./utils");
Object.defineProperty(exports, "parseInjectModules", { enumerable: true, get: function () { return utils_4.parseInjectModules; } });
Object.defineProperty(exports, "parseExtApiProviders", { enumerable: true, get: function () { return utils_4.parseExtApiProviders; } });
__exportStar(require("./sourceMap"), exports);
var stacktrace_2 = require("./stacktrace");
Object.defineProperty(exports, "parseRuntimeStacktrace", { enumerable: true, get: function () { return stacktrace_2.parseRuntimeStacktrace; } });
Object.defineProperty(exports, "parseUTSRuntimeStacktrace", { enumerable: true, get: function () { return stacktrace_2.parseUTSRuntimeStacktrace; } });
Object.defineProperty(exports, "parseUTSKotlinRuntimeStacktrace", { enumerable: true, get: function () { return stacktrace_2.parseUTSKotlinRuntimeStacktrace; } });
Object.defineProperty(exports, "parseUTSJavaScriptRuntimeStacktrace", { enumerable: true, get: function () { return stacktrace_2.parseUTSJavaScriptRuntimeStacktrace; } });
Object.defineProperty(exports, "parseUTSArkTSPluginStacktrace", { enumerable: true, get: function () { return stacktrace_2.parseUTSArkTSPluginStacktrace; } });
Object.defineProperty(exports, "resolveUTSKotlinFilenameByClassName", { enumerable: true, get: function () { return stacktrace_2.resolveUTSKotlinFilenameByClassName; } });
var kotlin_2 = require("./kotlin");
Object.defineProperty(exports, "toKotlin", { enumerable: true, get: function () { return kotlin_2.compile; } });
var swift_2 = require("./swift");
Object.defineProperty(exports, "toSwift", { enumerable: true, get: function () { return swift_2.compile; } });
function parseErrMsg(code, errMsg) {
    return code.replace(utils_1.ERR_MSG_PLACEHOLDER, errMsg);
}
function compileErrMsg(id) {
    return `uts插件[${id}]编译失败，无法使用`;
}
function warn(msg) {
    console.warn(`提示：${msg}`);
}
function createResult(dir, errMsg, code, deps, inject_apis, scoped_slots, custom_elements, meta) {
    return {
        dir,
        code: parseErrMsg(code, errMsg),
        deps,
        encrypt: false,
        inject_apis,
        scoped_slots,
        custom_elements,
        meta,
    };
}
// 重要：当调整参数时，需要同步调整 vue2 编译器 uni-cli-shared/lib/uts/uts-loader.js
async function compile(pluginDir, compilerOptions = {
    isX: false,
    isPlugin: true,
    isSingleThread: true,
}) {
    const isCompileUniModules = process.env.UNI_COMPILE_TARGET === 'uni_modules';
    const pkg = (0, utils_1.resolvePackage)(pluginDir);
    if (!pkg) {
        return;
    }
    // 加密插件
    if ((0, encrypt_1.isEncrypt)(pluginDir)) {
        return (0, encrypt_1.compileEncrypt)(pluginDir, compilerOptions.isX);
    }
    const { isX, extApis, isExtApi, transform, sourceMap, isSingleThread, uni_modules, rewriteConsoleExpr, } = compilerOptions;
    let isPlugin = compilerOptions.isPlugin;
    const cacheDir = process.env.HX_DEPENDENCIES_DIR || '';
    const inputDir = process.env.UNI_INPUT_DIR;
    const outputDir = process.env.UNI_OUTPUT_DIR;
    const utsPlatform = process.env.UNI_UTS_PLATFORM;
    const pluginRelativeDir = (0, path_1.relative)(isCompileUniModules ? (0, index_1.uvueOutDir)('app-android') : inputDir, pluginDir);
    const outputPluginDir = (0, shared_2.normalizePath)((0, path_1.join)(outputDir, pluginRelativeDir));
    const indexModuleFilename = (0, module_1.isModule)(pluginDir)
        ? (0, shared_2.normalizePath)((0, path_1.join)(pluginDir, 'index.module.uts'))
        : '';
    if (indexModuleFilename) {
        isPlugin = false;
    }
    const androidComponents = indexModuleFilename
        ? {}
        : (0, utils_1.resolveAndroidComponents)(pluginDir, pkg.is_uni_modules);
    const iosComponents = indexModuleFilename
        ? {}
        : (0, utils_1.resolveIOSComponents)(pluginDir, pkg.is_uni_modules);
    const customElements = (0, utils_1.resolveCustomElements)(pluginDir);
    const env = (0, manifest_1.initCheckOptionsEnv)();
    const deps = [];
    const inject_apis = [];
    const scoped_slots = [];
    const custom_elements = {};
    const meta = {
        exports: {},
        types: {},
        typeParams: [],
        components: [],
        customElements: Object.keys(customElements),
    };
    let moduleName = pkg.id;
    try {
        moduleName = require((0, path_1.join)(pluginDir, 'package.json')).displayName;
    }
    catch (e) { }
    const proxyCodeOptions = (0, shared_1.extend)({
        androidComponents,
        iosComponents,
        customElements,
        format: process.env.UNI_UTS_JS_CODE_FORMAT === 'cjs' ? "cjs" /* FORMATS.CJS */ : "es" /* FORMATS.ES */,
        pluginRelativeDir,
        moduleName,
        moduleType: process.env.UNI_UTS_MODULE_TYPE || '',
        meta,
        inputDir,
        isExtApi,
        androidPreprocessor: compilerOptions.androidPreprocessor,
        iosPreprocessor: compilerOptions.iosPreprocessor,
    }, pkg);
    const code = isCompileUniModules
        ? ''
        : await (0, code_1.genProxyCode)(pluginDir, proxyCodeOptions);
    let errMsg = '';
    if (process.env.NODE_ENV !== 'development' || isCompileUniModules) {
        // uts 插件 wgt 模式，本地资源模式不需要编译、ext-api模式也不需要编译（已经有前置编译过了）
        if (process.env.UNI_APP_PRODUCTION_TYPE === 'WGT' ||
            // 当编译 ext-api 中的 pages/components 时，不需要编译 utssdk 插件
            (process.env.UNI_COMPILE_TARGET === 'ext-api' &&
                (process.env.UNI_COMPILE_EXT_API_TYPE === 'pages' ||
                    process.env.UNI_COMPILE_EXT_API_TYPE === 'components'))) {
            const result = createResult(outputPluginDir, errMsg, code, deps, [], [], {}, meta);
            // 依赖的插件，不需要编译
            if (process.env.UNI_COMPILE_EXT_API_PLUGIN_ID &&
                process.env.UNI_COMPILE_EXT_API_PLUGIN_ID !== pkg.id) {
                result.code = (0, arkts_1.requireUTSPluginCode)(pkg.id, true);
                result.encrypt = true;
            }
            return result;
        }
        // 生产模式 支持同时生成 android 和 ios 的 uts 插件
        if (utsPlatform === 'app-android' ||
            utsPlatform === 'app' ||
            utsPlatform === 'app-plus') {
            let filename = indexModuleFilename ||
                (0, code_1.resolvePlatformIndex)('app-android', pluginDir, pkg) ||
                (0, code_1.resolveRootIndex)(pluginDir, pkg);
            if (!filename &&
                (Object.keys(androidComponents).length ||
                    Object.keys(customElements).length)) {
                filename = (0, code_1.resolvePlatformIndexFilename)('app-android', pluginDir, pkg);
            }
            if (filename) {
                const result = await (0, compiler_1.getCompiler)('kotlin').runProd(filename, {
                    components: androidComponents,
                    customElements,
                    uniModuleId: pkg.id,
                    isX,
                    isSingleThread,
                    isPlugin,
                    isExtApi,
                    isModule: !!indexModuleFilename,
                    extApis,
                    transform: await initCompilerOptionsTransform('kotlin', compilerOptions),
                    sourceMap: !!sourceMap,
                    hookClass: proxyCodeOptions.androidHookClass || '',
                    uniModules: uni_modules || [],
                    outFilename: indexModuleFilename
                        ? (0, shared_2.normalizePath)((0, path_1.join)(pluginRelativeDir, 'utssdk', 'app-android', 'index.kt'))
                        : '',
                });
                if (result) {
                    if (result.inject_apis) {
                        inject_apis.push(...result.inject_apis);
                    }
                    if (result.scoped_slots) {
                        scoped_slots.push(...result.scoped_slots);
                    }
                    const custom_elements = result.custom_elements || {};
                    Object.keys(custom_elements).forEach((key) => {
                        custom_elements[key] = custom_elements[key];
                    });
                }
                if (!isCompileUniModules && cacheDir) {
                    // 存储 sourcemap
                    (0, manifest_1.storeSourceMap)('app-android', pluginRelativeDir, outputDir, cacheDir, pkg.is_uni_modules);
                    (0, manifest_1.genManifestFile)('app-android', {
                        pluginDir,
                        env,
                        cacheDir,
                        pluginRelativeDir,
                        is_uni_modules: pkg.is_uni_modules,
                    });
                }
            }
        }
        if (utsPlatform === 'app-ios' ||
            utsPlatform === 'app' ||
            utsPlatform === 'app-plus') {
            let filename = indexModuleFilename ||
                (0, code_1.resolvePlatformIndex)('app-ios', pluginDir, pkg) ||
                (0, code_1.resolveRootIndex)(pluginDir, pkg);
            if (!filename &&
                (Object.keys(androidComponents).length ||
                    Object.keys(customElements).length)) {
                filename = (0, code_1.resolvePlatformIndexFilename)('app-ios', pluginDir, pkg);
            }
            if (filename) {
                const result = await (0, compiler_1.getCompiler)('swift').runProd(filename, {
                    components: iosComponents,
                    customElements,
                    uniModuleId: pkg.id,
                    isX,
                    isSingleThread,
                    isPlugin: true, // iOS 目前仅有 plugin 模式
                    isExtApi,
                    extApis,
                    transform: await initCompilerOptionsTransform('swift', compilerOptions),
                    sourceMap: !!sourceMap,
                    hookClass: proxyCodeOptions.iOSHookClass || '',
                    uniModules: uni_modules || [],
                });
                if (result) {
                    if (result.inject_apis) {
                        inject_apis.push(...result.inject_apis);
                    }
                    if (result.scoped_slots) {
                        scoped_slots.push(...result.scoped_slots);
                    }
                }
                if (!isCompileUniModules && cacheDir) {
                    (0, manifest_1.storeSourceMap)('app-ios', pluginRelativeDir, outputDir, cacheDir, pkg.is_uni_modules);
                    (0, manifest_1.genManifestFile)('app-ios', {
                        pluginDir,
                        env,
                        cacheDir,
                        pluginRelativeDir,
                        is_uni_modules: pkg.is_uni_modules,
                    });
                }
            }
        }
    }
    else {
        const compilerType = utsPlatform === 'app-android' ? 'kotlin' : 'swift';
        const versionTips = (0, compiler_1.getCompiler)(compilerType).checkVersionTips(pkg.id, pluginDir, pkg.is_uni_modules);
        // iOS windows 平台，标准基座不编译
        if (utsPlatform === 'app-ios') {
            if (shared_2.isWindows) {
                process.env.UNI_UTS_ERRORS = `iOS手机在windows上使用标准基座真机运行无法使用uts插件，如需使用uts插件请提交云端打包自定义基座`;
                return createResult(outputPluginDir, errMsg, code, deps, [], [], {}, meta);
            }
        }
        if (utsPlatform === 'app-android' || utsPlatform === 'app-ios') {
            const components = utsPlatform === 'app-android' ? androidComponents : iosComponents;
            let tips = '';
            // dev 模式
            if (cacheDir) {
                // 检查缓存
                // let start = Date.now()
                // console.log('uts插件[' + pkg.id + ']start', start)
                const res = await (0, manifest_1.checkCompile)(utsPlatform, process.env.HX_USE_BASE_TYPE, {
                    id: pkg.id,
                    env,
                    cacheDir,
                    outputDir,
                    pluginDir,
                    pluginRelativeDir,
                    is_uni_modules: pkg.is_uni_modules,
                });
                if (res.tips) {
                    tips = res.tips;
                }
                // console.log('uts插件[' + pkg.id + ']end', Date.now())
                // console.log('uts插件[' + pkg.id + ']缓存检查耗时：', Date.now() - start)
                if (!res.expired) {
                    if (utsPlatform === 'app-android') {
                        // debugger 专用
                        (0, dex_1.restoreDebuggerFiles)(pluginRelativeDir, cacheDir, outputDir, pkg.is_uni_modules, inputDir, rewriteConsoleExpr);
                        (0, manifest_1.restoreDex)(pluginRelativeDir, cacheDir, outputDir, pkg.is_uni_modules);
                    }
                    // 还原 sourcemap
                    (0, manifest_1.restoreSourceMap)(utsPlatform, pluginRelativeDir, outputDir, cacheDir, pkg.is_uni_modules);
                    // 处理 config.json
                    (0, utils_1.genConfigJson)(utsPlatform, isX, (utsPlatform === 'app-android'
                        ? proxyCodeOptions.androidHookClass
                        : proxyCodeOptions.iOSHookClass) || '', components, customElements, pluginRelativeDir, pkg.is_uni_modules, inputDir, outputDir, (0, utils_1.resolveConfigProvider)(utsPlatform, pkg.id, transform));
                    console.log((0, utils_2.cacheTips)(pkg.id));
                    if (res.tips) {
                        warn(res.tips);
                    }
                    if (versionTips) {
                        warn(versionTips);
                    }
                    // 所有文件加入依赖
                    return createResult(outputPluginDir, errMsg, code, res.files.map((name) => (0, path_1.join)(pluginDir, name)), [], [], {}, meta);
                }
            }
            let filename = (0, code_1.resolvePlatformIndex)(utsPlatform, pluginDir, pkg) ||
                (0, code_1.resolveRootIndex)(pluginDir, pkg);
            if (!filename &&
                (Object.keys(components).length || Object.keys(customElements).length)) {
                filename = (0, code_1.resolvePlatformIndexFilename)(utsPlatform, pluginDir, pkg);
            }
            if (filename) {
                deps.push(filename);
                if (utsPlatform === 'app-android') {
                    deps.push(...(0, kotlin_1.resolveAndroidDepFiles)(filename));
                }
                else {
                    deps.push(...(0, swift_1.resolveIOSDepFiles)(filename));
                }
                // 处理 config.json
                (0, utils_1.genConfigJson)(utsPlatform, isX, (utsPlatform === 'app-android'
                    ? proxyCodeOptions.androidHookClass
                    : proxyCodeOptions.iOSHookClass) || '', components, customElements, pluginRelativeDir, pkg.is_uni_modules, inputDir, outputDir, (0, utils_1.resolveConfigProvider)(utsPlatform, pkg.id, transform));
                const res = await (0, compiler_1.getCompiler)(compilerType).runDev(filename, {
                    components,
                    customElements,
                    isX,
                    isSingleThread,
                    isPlugin,
                    isExtApi,
                    cacheDir,
                    pluginRelativeDir,
                    is_uni_modules: pkg.is_uni_modules,
                    rewriteConsoleExpr,
                    extApis,
                    transform: await initCompilerOptionsTransform(compilerType, compilerOptions),
                    sourceMap: !!sourceMap,
                    uniModules: uni_modules || [],
                });
                if (res) {
                    if (res.code) {
                        //重要：该日志会被HBuilderX使用，用于识别uts插件编译是否失败，如果调整文案，需要通知HBuilderX。
                        console.error(`uts插件[${pkg.id}]编译失败`);
                    }
                    if ((0, shared_1.isArray)(res.deps) && res.deps.length) {
                        // 添加其他文件的依赖
                        deps.push(...res.deps);
                    }
                    let isSuccess = false;
                    if (res.type === 'swift') {
                        if (res.code) {
                            errMsg = compileErrMsg(pkg.id);
                            try {
                                const stacktrace = await (0, stacktrace_1.parseUTSSwiftPluginStacktrace)({
                                    stacktrace: res.msg,
                                    sourceMapFile: (0, sourceMap_1.resolveUTSPluginSourceMapFile)('swift', filename, inputDir, outputDir),
                                    sourceRoot: inputDir,
                                });
                                console.log(stacktrace);
                            }
                            catch (e) {
                                console.error(`error: ` + res.msg);
                            }
                        }
                        else {
                            isSuccess = true;
                        }
                    }
                    else if (res.type === 'kotlin') {
                        if (res.changed.length) {
                            isSuccess = true;
                        }
                    }
                    if (isSuccess) {
                        // 生成缓存文件
                        if (cacheDir) {
                            // 存储 sourcemap
                            (0, manifest_1.storeSourceMap)(utsPlatform, pluginRelativeDir, outputDir, cacheDir, pkg.is_uni_modules);
                            // 生成 manifest
                            (0, manifest_1.genManifestFile)(utsPlatform, {
                                pluginDir,
                                env,
                                cacheDir,
                                pluginRelativeDir,
                                is_uni_modules: pkg.is_uni_modules,
                            });
                        }
                        if (tips) {
                            warn(tips);
                        }
                        if (versionTips) {
                            warn(versionTips);
                        }
                    }
                    const files = [];
                    if (process.env.UNI_APP_UTS_CHANGED_FILES) {
                        try {
                            files.push(...JSON.parse(process.env.UNI_APP_UTS_CHANGED_FILES));
                        }
                        catch (e) { }
                    }
                    if (res.changed && res.changed.length) {
                        files.push(...res.changed);
                    }
                    else {
                        if (res.type === 'kotlin') {
                            errMsg = compileErrMsg(pkg.id);
                        }
                    }
                    process.env.UNI_APP_UTS_CHANGED_FILES = JSON.stringify([
                        ...new Set(files),
                    ]);
                }
                else {
                    errMsg = compileErrMsg(pkg.id);
                }
            }
        }
    }
    return createResult(outputPluginDir, errMsg, code, deps, inject_apis, scoped_slots, custom_elements, meta);
}
exports.compile = compile;
async function initCompilerOptionsTransform(compilerType, options) {
    const transform = JSON.parse(JSON.stringify(options.transform || {}));
    const customAutoImports = await initCompilerOptionsTransformAutoImports(compilerType === 'kotlin'
        ? options.kotlinAutoImports
        : options.swiftAutoImports);
    if (customAutoImports && Object.keys(customAutoImports).length) {
        const autoImports = transform.autoImports || {};
        Object.keys(customAutoImports).forEach((source) => {
            if (autoImports[source]) {
                autoImports[source].push(...customAutoImports[source]);
            }
            else {
                autoImports[source] = customAutoImports[source];
            }
        });
        transform.autoImports = autoImports;
    }
    return transform;
}
exports.initCompilerOptionsTransform = initCompilerOptionsTransform;
async function initCompilerOptionsTransformAutoImports(autoImports) {
    return autoImports?.();
}
function emptyCacheDir(platform, inputDir, pluginDir) {
    const outputPluginDir = (0, uni_modules_1.resolveOutputPluginDir)(platform, inputDir, pluginDir);
    const uvueOutputPluginDir = (0, uni_modules_1.resolveUVueOutputPluginDir)(platform, inputDir, pluginDir);
    if ((0, fs_extra_1.existsSync)(outputPluginDir)) {
        emptyDir(outputPluginDir);
    }
    if ((0, fs_extra_1.existsSync)(uvueOutputPluginDir)) {
        emptyDir(uvueOutputPluginDir);
    }
}
function emptyDir(dir) {
    try {
        for (const file of (0, fs_extra_1.readdirSync)(dir)) {
            // node >= 14.14.0
            (0, fs_extra_1.rmSync)((0, path_1.resolve)(dir, file), { recursive: true, force: true });
        }
    }
    catch (e) { }
}
/**
 * 发行模式(会自动清理临时目录)
 * 目前仅 ext-api 框架的地方使用了
 * @param platform
 * @param pluginDir
 * @param param2
 * @param compilerOptions
 */
async function buildUniModules(platform, pluginDir, options, compilerOptions) {
    const inputDir = process.env.UNI_INPUT_DIR;
    const syncUniModulesFilePreprocessors = options.transformVueFile
        ? patchSyncUniModulesFilePreprocessors(options.syncUniModulesFilePreprocessors, options.transformVueFile)
        : options.syncUniModulesFilePreprocessors;
    if (platform === 'app-android' || platform === 'app') {
        const platform = 'app-android';
        emptyCacheDir(platform, inputDir, pluginDir);
        await (0, uni_modules_1.compileUniModuleWithTsc)('app-android', pluginDir, (0, uni_modules_1.createUniXKotlinCompiler)(), {
            rootFiles: options.rootFiles,
            preprocessor: syncUniModulesFilePreprocessors.android,
        });
    }
    if (platform === 'app-ios' || platform === 'app') {
        const platform = 'app-ios';
        emptyCacheDir(platform, inputDir, pluginDir);
        await (0, uni_modules_1.compileUniModuleWithTsc)('app-ios', pluginDir, (0, uni_modules_1.createUniXSwiftCompiler)(), {
            rootFiles: options.rootFiles,
            preprocessor: syncUniModulesFilePreprocessors.ios,
        });
    }
    if (platform === 'app-harmony') {
        const platform = 'app-harmony';
        emptyCacheDir(platform, inputDir, pluginDir);
        await (0, uni_modules_1.compileUniModuleWithTsc)('app-harmony', pluginDir, (0, uni_modules_1.createUniXArkTSCompiler)(), {
            rootFiles: options.rootFiles,
            preprocessor: syncUniModulesFilePreprocessors.harmony,
        });
    }
    if (process.env.UNI_UTS_MODULE_TYPE === 'built-in') {
        compilerOptions.androidPreprocessor =
            syncUniModulesFilePreprocessors.android;
        compilerOptions.iosPreprocessor = syncUniModulesFilePreprocessors.ios;
        compilerOptions.harmonyPreprocessor =
            syncUniModulesFilePreprocessors.harmony;
    }
    if (platform === 'app-harmony') {
        return (0, arkts_1.compileArkTS)(pluginDir, {
            isX: compilerOptions.isX,
            isExtApi: compilerOptions.isExtApi,
            sourceMap: compilerOptions.sourceMap,
            rewriteConsoleExpr: compilerOptions.rewriteConsoleExpr,
            transform: {
                uniExtApiProviderName: compilerOptions.transform?.uniExtApiProviderName,
                uniExtApiProviderService: compilerOptions.transform?.uniExtApiProviderService,
                uniExtApiProviderServicePlugin: compilerOptions.transform?.uniExtApiProviderServicePlugin,
            },
        });
    }
    return compile(pluginDir, compilerOptions);
}
exports.buildUniModules = buildUniModules;
function patchSyncUniModulesFilePreprocessors(syncUniModulesFilePreprocessors, transformVueFile) {
    return {
        android: patchSyncUniModulesFilePreprocessor('app-android', syncUniModulesFilePreprocessors.android, transformVueFile),
        ios: patchSyncUniModulesFilePreprocessor('app-ios', syncUniModulesFilePreprocessors.ios, transformVueFile),
        harmony: patchSyncUniModulesFilePreprocessor('app-harmony', syncUniModulesFilePreprocessors.harmony, transformVueFile),
    };
}
function patchSyncUniModulesFilePreprocessor(platform, preprocessor, transformVueFile) {
    return async (content, fileName) => {
        const fileExtname = (0, path_1.extname)(fileName);
        if (['.vue', '.uvue'].includes(fileExtname)) {
            return transformVueFile(platform, fileName);
        }
        return preprocessor(content, fileName);
    };
}
__exportStar(require("./uni_modules"), exports);
