import { generateCodeFrameWithKotlinStacktrace, generateCodeFrameWithSwiftStacktrace } from './legacy';
import type { UTSOutputOptions } from '@dcloudio/uts';
import { type SyncUniModulesFilePreprocessor, type UniXCompilerPlatform } from './uni_modules';
export * from './tsc';
export { getPluginInjectApis, getPluginInjectComponents } from './utils';
export { parseExportIdentifiers, parseInterfaceTypes } from './code';
export { compileArkTS, compileArkTSExtApi, getArkTSAutoImports, resolveAppHarmonyUniModulesRootDir, resolveAppHarmonyUniModulesEntryDir, } from './arkts';
export declare const sourcemap: {
    generateCodeFrameWithKotlinStacktrace: typeof generateCodeFrameWithKotlinStacktrace;
    generateCodeFrameWithSwiftStacktrace: typeof generateCodeFrameWithSwiftStacktrace;
};
export { compileApp, CompileAppOptions } from './uvue/index';
export { parseInjectModules, parseExtApiProviders } from './utils';
export * from './sourceMap';
export { parseRuntimeStacktrace, parseUTSRuntimeStacktrace, parseUTSKotlinRuntimeStacktrace, parseUTSJavaScriptRuntimeStacktrace, parseUTSArkTSPluginStacktrace, resolveUTSKotlinFilenameByClassName, } from './stacktrace';
export { compile as toKotlin } from './kotlin';
export { compile as toSwift } from './swift';
export interface CompileResult {
    code: string;
    deps: string[];
    encrypt: boolean;
    meta?: any;
    dir: string;
    inject_apis: string[];
    scoped_slots: string[];
    custom_elements: Record<string, string>;
}
export interface UTSPluginCompilerOptions {
    isX: boolean;
    isPlugin: boolean;
    isSingleThread: boolean;
    isExtApi?: boolean;
    extApis?: Record<string, [string, string]>;
    transform?: UTSOutputOptions['transform'];
    sourceMap?: boolean;
    uni_modules?: string[];
    kotlinAutoImports?: () => Promise<Required<UTSOutputOptions>['transform']['autoImports']>;
    swiftAutoImports?: () => Promise<Required<UTSOutputOptions>['transform']['autoImports']>;
    androidPreprocessor?: SyncUniModulesFilePreprocessor;
    iosPreprocessor?: SyncUniModulesFilePreprocessor;
    harmonyPreprocessor?: SyncUniModulesFilePreprocessor;
    rewriteConsoleExpr?: (fileName: string, content: string) => string;
}
export declare function compile(pluginDir: string, compilerOptions?: UTSPluginCompilerOptions): Promise<CompileResult | void>;
export declare function initCompilerOptionsTransform(compilerType: 'kotlin' | 'swift', options: UTSPluginCompilerOptions): Promise<{
    enableUtsNumber?: boolean | undefined;
    enableNarrowType?: boolean | undefined;
    enableGenericsParameterDefaults?: boolean | undefined;
    enableInlineReified?: boolean | undefined;
    paramDefaultValue?: boolean | undefined;
    constructorInvocation?: boolean | undefined;
    uniExtApiDefaultNamespace?: string | undefined;
    uniExtApiNamespaces?: Record<string, [string, string]> | undefined;
    uniExtApiDefaultParameters?: Record<string, string[]> | undefined;
    uniExtApiProviderName?: string | undefined;
    uniExtApiProviderService?: string | undefined;
    uniExtApiProviderServicePlugin?: string | undefined;
    uniExtApiProviders?: [string, string, string][] | undefined;
    uvueClassNamePrefix?: string | undefined;
    uvueClassNameOnlyBasename?: boolean | undefined;
    uvueGenDefaultAs?: string | undefined;
    disableReactiveObject?: boolean | undefined;
    reactiveObjects?: string[] | undefined;
    reactiveAll?: boolean | undefined;
    uniCloudObjectInfo?: {
        name: string;
        methodList: string[];
    }[] | undefined;
    autoImports?: Record<string, [string, (string | undefined)?][]> | undefined;
    autoImportExternals?: Record<string, [string, (string | undefined)?][]> | undefined;
    uniModulesArtifacts?: {
        name: string;
        package: string;
        scopedSlots: string[];
        declaration: string;
    }[] | undefined;
}>;
/**
 * 发行模式(会自动清理临时目录)
 * 目前仅 ext-api 框架的地方使用了
 * @param platform
 * @param pluginDir
 * @param param2
 * @param compilerOptions
 */
export declare function buildUniModules(platform: 'app' | 'app-android' | 'app-ios' | 'app-harmony', pluginDir: string, options: {
    syncUniModulesFilePreprocessors: {
        android: SyncUniModulesFilePreprocessor;
        ios: SyncUniModulesFilePreprocessor;
        harmony: SyncUniModulesFilePreprocessor;
    };
    transformVueFile?: (platform: UniXCompilerPlatform, fileName: string) => Promise<string>;
    rootFiles?: string[];
}, compilerOptions: UTSPluginCompilerOptions): Promise<void | CompileResult>;
export * from './uni_modules';
