import type { CompileResult } from '.';
interface ArkTSCompilerOptions {
    isX?: boolean;
    isExtApi?: boolean;
    isOhpmPackage?: boolean;
    sourceMap?: boolean;
    uni_modules?: string[];
    rewriteConsoleExpr?: (fileName: string, content: string) => string;
    transform?: {
        uniExtApiProviderName?: string;
        uniExtApiProviderService?: string;
        uniExtApiProviderServicePlugin?: string;
    };
}
type AutoImportOptions = Record<string, [string, (string | undefined)?][]>;
export declare function mergeArkTSAutoImports(...autoImports: AutoImportOptions[]): AutoImportOptions;
export declare function getArkTSAutoImports(isX?: boolean): AutoImportOptions;
export declare function compileArkTSExtApi(rootDir: string, pluginDir: string, outputDir: string, { isExtApi, isX, isOhpmPackage, sourceMap, uni_modules, rewriteConsoleExpr, }: ArkTSCompilerOptions): Promise<CompileResult | void>;
export declare function compileArkTS(pluginDir: string, options: ArkTSCompilerOptions): Promise<CompileResult | void>;
export declare function requireUTSPluginCode(pluginId: string, _isExtApi: boolean): string;
export declare function resolveAppHarmonyUniModulesRootDir(): string;
export declare function resolveAppHarmonyUniModuleDir(pluginId: string): string;
export declare function resolveAppHarmonyUniModulesEntryDir(): string;
export {};
