export type CreateVideoContext = (videoId: string.VideoIdString, component?: ComponentPublicInstance | null) => VideoContext | null;

export type Danmu = {
    /**
     * 弹幕文字
     */
    text?: string | null,
    /**
     * 弹幕颜色
     */
    color?: string | null,
    /**
     * 显示时刻
     */
    time?: number | null
};

export type RequestFullScreenOptions = {
    /**
     * direction
     * @uniPlatform {
     *   "app": {
     *     "android": {
     *       "osVer": "4.4",
     *       "uniVer": "√",
     *       "unixVer": "3.9.0"
     *     },
     *     "ios": {
     *       "osVer": "12.0",
     *       "uniVer": "√",
     *       "unixVer": "4.11"
     *     }
     *   },
    *  "mp": {
    *    "weixin": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "4.41"
    *    },
    *    "alipay": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "baidu": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "toutiao": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "lark": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "qq": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "kuaishou": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "jd": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    }
    *  },
     *   "web": {
     *     "uniVer": "x",
     *     "unixVer": "x"
     *   }
     * }
     */
    direction?:
    /**
     * 正常竖向
     */
    0 |
    /**
     * 屏幕逆时针90度
     */
    90 |
    /**
     * 屏幕顺时针90度
     */
    -90 | null
};

export interface VideoContext {
    /**
     * @description 播放
     * @uniPlatform {
     *   "app": {
     *     "android": {
     *       "osVer": "4.4",
     *       "uniVer": "√",
     *       "unixVer": "3.9.0"
     *     },
     *     "ios": {
     *       "osVer": "12.0",
     *       "uniVer": "√",
     *       "unixVer": "4.11"
     *     },
     *    "harmony": {
     *      "osVer": "3.0",
     *      "uniVer": "4.23",
     *      "unixVer": "x"
     *    }
     *   },
    *  "mp": {
    *    "weixin": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "4.41"
    *    },
    *    "alipay": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "baidu": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "toutiao": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "lark": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "qq": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "kuaishou": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "jd": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    }
    *  },
     *   "web": {
     *     "uniVer": "√",
     *     "unixVer": "4.0"
     *   }
     * }
     * @uniVueVersion 2,3
     */
    play(): void;
    /**
     * @description 暂停
     * @uniPlatform {
     *   "app": {
     *     "android": {
     *       "osVer": "4.4",
     *       "uniVer": "√",
     *       "unixVer": "3.9.0"
     *     },
     *     "ios": {
     *       "osVer": "12.0",
     *       "uniVer": "√",
     *       "unixVer": "4.11"
     *     },
     *    "harmony": {
     *      "osVer": "3.0",
     *      "uniVer": "4.23",
     *      "unixVer": "x"
     *    }
     *   },
    *  "mp": {
    *    "weixin": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "4.41"
    *    },
    *    "alipay": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "baidu": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "toutiao": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "lark": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "qq": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "kuaishou": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "jd": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    }
    *  },
     *   "web": {
     *     "uniVer": "√",
     *     "unixVer": "4.0"
     *   }
     * }
     * @uniVueVersion 2,3
     */
    pause(): void;
    /**
     * @description 跳转到指定位置
     * @param {number} position 跳转到指定位置(秒)
     * @uniPlatform {
     *   "app": {
     *     "android": {
     *       "osVer": "4.4",
     *       "uniVer": "√",
     *       "unixVer": "3.9.0"
     *     },
     *     "ios": {
     *       "osVer": "12.0",
     *       "uniVer": "√",
     *       "unixVer": "4.11"
     *     },
     *    "harmony": {
     *      "osVer": "3.0",
     *      "uniVer": "4.23",
     *      "unixVer": "x"
     *    }
     *   },
    *  "mp": {
    *    "weixin": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "4.41"
    *    },
    *    "alipay": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "baidu": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "toutiao": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "lark": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "qq": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "kuaishou": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "jd": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    }
    *  },
     *   "web": {
     *     "uniVer": "√",
     *     "unixVer": "4.0"
     *   }
     * }
     * @uniVueVersion 2,3
     */
    seek(position: number): void;
    /**
     * @description 停止视频
     * @uniPlatform {
     *   "app": {
     *     "android": {
     *       "osVer": "4.4",
     *       "uniVer": "√",
     *       "unixVer": "3.9.0"
     *     },
     *     "ios": {
     *       "osVer": "12.0",
     *       "uniVer": "√",
     *       "unixVer": "4.11"
     *     },
     *    "harmony": {
     *      "osVer": "3.0",
     *      "uniVer": "4.23",
     *      "unixVer": "x"
     *    }
     *   },
    *  "mp": {
    *    "weixin": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "4.41"
    *    },
    *    "alipay": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "baidu": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "toutiao": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "lark": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "qq": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "kuaishou": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "jd": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    }
    *  },
     *   "web": {
     *     "uniVer": "√",
     *     "unixVer": "4.0"
     *   }
     * }
     * @uniVueVersion 2,3
     */
    stop(): void;
    /**
     * @description 发送弹幕
     * @param {Danmu} 属性 text, color
     * @uniPlatform {
     *   "app": {
     *     "android": {
     *       "osVer": "4.4",
     *       "uniVer": "√",
     *       "unixVer": "3.9.0"
     *     },
     *     "ios": {
     *       "osVer": "12.0",
     *       "uniVer": "√",
     *       "unixVer": "4.11"
     *     },
     *    "harmony": {
     *      "osVer": "3.0",
     *      "uniVer": "4.23",
     *      "unixVer": "x"
     *    }
     *   },
    *  "mp": {
    *    "weixin": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "4.41"
    *    },
    *    "alipay": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "baidu": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "toutiao": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "lark": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "qq": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "kuaishou": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "jd": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    }
    *  },
     *   "web": {
     *     "uniVer": "√",
     *     "unixVer": "4.0"
     *   }
     * }
     * @uniVueVersion 2,3
     */
    sendDanmu(danmu: Danmu): void;
    /**
     * @description 设置倍速播放
     * @param {number} rate, 支持倍率 0.5/0.8/1.0/1.25/1.5
     * @uniPlatform {
     *   "app": {
     *     "android": {
     *       "osVer": "4.4",
     *       "uniVer": "√",
     *       "unixVer": "3.9.0"
     *     },
     *     "ios": {
     *       "osVer": "12.0",
     *       "uniVer": "√",
     *       "unixVer": "4.11"
     *     },
     *    "harmony": {
     *      "osVer": "3.0",
     *      "uniVer": "4.23",
     *      "unixVer": "x"
     *    }
     *   },
    *  "mp": {
    *    "weixin": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "4.41"
    *    },
    *    "alipay": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "baidu": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "toutiao": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "lark": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "qq": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "kuaishou": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "jd": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    }
    *  },
     *   "web": {
     *     "uniVer": "√",
     *     "unixVer": "4.0"
     *   }
     * }
     * @uniVueVersion 2,3
     */
    playbackRate(rate: number): void;
    /**
     * @description 进入全屏
     * @param {RequestFullScreenOptions} direction, 0|正常竖向, 90|屏幕逆时针90度, -90|屏幕顺时针90度
     * @uniPlatform {
     *   "app": {
     *     "android": {
     *       "osVer": "4.4",
     *       "uniVer": "√",
     *       "unixVer": "3.9.0"
     *     },
     *     "ios": {
     *       "osVer": "12.0",
     *       "uniVer": "√",
     *       "unixVer": "4.11"
     *     },
     *    "harmony": {
     *      "osVer": "3.0",
     *      "uniVer": "4.23",
     *      "unixVer": "x"
     *    }
     *   },
    *  "mp": {
    *    "weixin": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "4.41"
    *    },
    *    "alipay": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "baidu": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "toutiao": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "lark": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "qq": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "kuaishou": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "jd": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    }
    *  },
     *   "web": {
     *     "uniVer": "√",
     *     "unixVer": "4.0"
     *   }
     * }
     * @uniVueVersion 2,3
     */
    requestFullScreen(direction?: RequestFullScreenOptions | null): void;
    /**
     * 退出全屏
     * @description 退出全屏
     * @uniPlatform {
     *   "app": {
     *     "android": {
     *       "osVer": "4.4",
     *       "uniVer": "√",
     *       "unixVer": "3.9.0"
     *     },
     *     "ios": {
     *       "osVer": "12.0",
     *       "uniVer": "√",
     *       "unixVer": "4.11"
     *     },
     *    "harmony": {
     *      "osVer": "3.0",
     *      "uniVer": "4.23",
     *      "unixVer": "x"
     *    }
     *   },
    *  "mp": {
    *    "weixin": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "4.41"
    *    },
    *    "alipay": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "baidu": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "toutiao": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "lark": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "qq": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "kuaishou": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    },
    *    "jd": {
    *        "hostVer": "√",
    *        "uniVer": "√",
    *        "unixVer": "x"
    *    }
    *  },
     *   "web": {
     *     "uniVer": "√",
     *     "unixVer": "4.0"
     *   }
     * }
     * @uniVueVersion 2,3
     */
    exitFullScreen(): void;
}

export interface Uni {
    /**
     * 创建并返回 video 上下文 videoContext 对象
     * @uniPlatform {
     *   "app": {
     *     "android": {
     *       "osVer": "4.4",
     *       "uniVer": "√",
     *       "unixVer": "√"
     *     },
     *     "ios": {
     *       "osVer": "12.0",
     *       "uniVer": "√",
     *       "unixVer": "4.11"
     *     },
     *     "harmony": {
     *       "osVer": "5.0.0",
     *       "uniVer": "4.23",
     *       "unixVer": "4.61"
     *     }
     *   },
     *   "web": {
     *     "uniVer": "√",
     *     "unixVer": "4.0"
     *   },
     *   "mp": {
     *     "weixin": {
     *       "hostVer": "1.9.6",
     *       "uniVer": "√",
     *       "unixVer": "4.41"
     *     },
     *     "alipay": {
     *       "hostVer": "1.10.0",
     *       "uniVer": "√",
     *       "unixVer": "x"
     *     },
     *     "baidu": {
     *       "hostVer": "√",
     *       "uniVer": "√",
     *       "unixVer": "x"
     *     },
     *     "toutiao": {
     *       "hostVer": "√",
     *       "uniVer": "√",
     *       "unixVer": "x"
     *     },
     *     "lark": {
     *       "hostVer": "√",
     *       "uniVer": "√",
     *       "unixVer": "x"
     *     },
     *     "qq": {
     *       "hostVer": "√",
     *       "uniVer": "√",
     *       "unixVer": "x"
     *     },
     *     "kuaishou": {
     *       "hostVer": "√",
     *       "uniVer": "√",
     *       "unixVer": "x"
     *     },
     *     "jd": {
     *       "hostVer": "√",
     *       "uniVer": "√",
     *       "unixVer": "x"
     *     }
     *   }
     * }
     * @uniVueVersion 2,3
     * @return {VideoContext} video组件上下文对象
     *
     * @tutorial-uni-app https://uniapp.dcloud.net.cn/api/media/video-context.html#createvideocontext
     * @tutorial-uni-app-x https://doc.dcloud.net.cn/uni-app-x/api/create-video-context.html#createvideocontext
     * @tutorial https://doc.dcloud.net.cn/uni-app-x/api/create-video-context.html#createvideocontext
     * @tutorial_weixin https://developers.weixin.qq.com/miniprogram/dev/api/media/video/VideoContext.html
     */
    createVideoContext: CreateVideoContext
}

/**
 * 通用事件
 * 临时方案，规避组件Event接口无法直接继承UniEvent的问题
 */
export interface UniVideoEvent {
    /**
     * 是否冒泡
     */
    bubbles: boolean
    /**
     * 是否可以取消
     */
    cancelable: boolean
    /**
     * 事件类型
     */
    type: string
    /**
     * 触发事件的组件
     */
    target?: UniElement | null
    /**
     * 当前组件
     */
    currentTarget?: UniElement | null
    // #ifndef APP-HARMONY
    /**
     * 事件发生时的时间戳
     */
    timeStamp: Long
    // #endif
    // #ifdef APP-HARMONY
    /**
     * 事件发生时的时间戳
     */
    timeStamp: number
    // #endif
    /**
     * 阻止当前事件的进一步传播
     */
    stopPropagation(): void
    /**
     * 阻止当前事件的默认行为
     */
    preventDefault(): void
}

/**
 * timeupdate 事件
 * 播放进度变化时触发
 */
export interface UniVideoTimeUpdateEvent extends UniVideoEvent {
    detail: UniVideoTimeUpdateEventDetail
}

export type UniVideoTimeUpdateEventDetail = {
    /**
     * 当前进度
     */
    currentTime: number,
    /**
     * 总进度
     */
    duration: number
}

/**
 * fullscreenchange 事件
 * 当视频进入和退出全屏是触发
 */
export interface UniVideoFullScreenChangeEvent extends UniVideoEvent {
    detail: UniVideoFullScreenChangeEventDetail
}

export type UniVideoFullScreenDirection =
/**
 * 竖屏
 */
'vertical' |
/**
 * 横屏
 */
'horizontal'

export type UniVideoFullScreenChangeEventDetail = {
    /**
     * 是否全屏
     */
    fullScreen: boolean,
    /**
     * 横竖屏
     */
    direction: UniVideoFullScreenDirection
}

/**
 * error 事件
 * 视频播放出错时触发
 */
export interface UniVideoErrorEvent extends UniVideoEvent {
    detail: VideoError
}

/**
 * 统一错误码
 */
export type VideoErrorCode =
/**
 * 网络错误
 */
100001 |
/**
 * 内部错误
 */
200001 |
/**
 * SDK错误
 */
300001

export interface VideoError extends IUniError {
    errCode: VideoErrorCode
}

/**
 * progress 事件
 * 加载进度变化时触发
 */
export interface UniVideoProgressEvent extends UniVideoEvent {
    detail: UniVideoProgressEventDetail
}

export type UniVideoProgressEventDetail = {
    /**
     * 加载进度百分比
     */
    buffered: number
}

/**
 * fullscreenclick 事件
 * 视频播放全屏播放时点击事件
 */
export interface UniVideoFullScreenClickEvent extends UniVideoEvent {
    detail: UniVideoFullScreenClickEventDetail
}

export type UniVideoFullScreenClickEventDetail = {
    /**
     * 点击点相对于屏幕左侧边缘的 X 轴坐标
     */
    screenX: number,
    /**
     * 点击点相对于屏幕顶部边缘的 Y 轴坐标
     */
    screenY: number,
    /**
     * 屏幕总宽度
     */
    screenWidth: number,
    /**
     * 屏幕总高度
     */
    screenHeight: number
}

/**
 * controlstoggle 事件
 * 切换播放控件显示隐藏时触发
 */
export interface UniVideoControlsToggleEvent extends UniVideoEvent {
    detail: UniVideoControlsToggleEventDetail
}

export type UniVideoControlsToggleEventDetail = {
    /**
     * 是否显示
     */
    show: boolean
}

export type VideoTimeUpdateEvent = UniVideoTimeUpdateEvent
export type VideoTimeUpdateEventDetail = UniVideoTimeUpdateEventDetail
export type VideoFullScreenChangeEvent = UniVideoFullScreenChangeEvent
export type VideoFullScreenChangeEventDetail = UniVideoFullScreenChangeEventDetail
export type VideoErrorEvent = UniVideoErrorEvent
export type VideoProgressEvent = UniVideoProgressEvent
export type VideoProgressEventDetail = UniVideoProgressEventDetail
export type VideoFullScreenClickEvent = UniVideoFullScreenClickEvent
export type VideoFullScreenClickEventDetail = UniVideoFullScreenClickEventDetail
export type VideoControlsToggleEvent = UniVideoControlsToggleEvent
export type VideoControlsToggleEventDetail = UniVideoControlsToggleEventDetail
