export interface Uni {
	/**
	  * @deprecated 已废弃，仅为了向下兼容保留，建议使用`getUniVerifyManager`。
	  * @description 获取一键登录管理对象
	  * @tutorial https://uniapp.dcloud.net.cn/univerify.html#univerifymanager
	  * @uniPlatform {
	  *  "app": {
	  * 	  "android": {
	  *     	"osVer": "5.0",
	  *  		  "uniVer": "√",
	  * 		  "unixVer": "3.99"
	  *  	  },
	  *     "ios": {
	  *       "osVer": "12.0",
	  *  		  "uniVer": "√",
	  * 		  "unixVer": "4.18"
	  *     },
	 *       "harmony": {
	 *       		"osVer": "5.0.0",
	 *  		  	"uniVer": "4.61",
	 * 		  		"unixVer": "4.61"
	 *       }
	  *   },
	  *  "web": {
	  * 	 "uniVer": "x",
	*    "unixVer": "x"
	  *  }
	  * }
	  */
	getUniverifyManager(): UniverifyManager

	/**
	  * @description 获取一键登录管理对象
	  * @tutorial https://uniapp.dcloud.net.cn/univerify.html#univerifymanager
	  * @uniPlatform {
	  *  "app": {
	  * 	  "android": {
	  *     	"osVer": "5.0",
	  *  		  "uniVer": "√",
	  * 		  "unixVer": "4.42"
	  *  	  },
	  *     "ios": {
	  *       "osVer": "12.0",
	  *  		  "uniVer": "√",
	  * 		  "unixVer": "4.42"
	  *     },
	 *       "harmony": {
	 *       		"osVer": "5.0.0",
	 *  		  	"uniVer": "4.61",
	 * 		  		"unixVer": "4.61"
	 *       }
	  *   },
	  *  "web": {
	  * 	 "uniVer": "x",
	*    "unixVer": "x"
	  *  }
	  * }
	  */
	getUniVerifyManager(): UniVerifyManager
}
export type GetUniverifyManager = () => UniverifyManager

export type GetUniVerifyManager = () => UniVerifyManager

// #ifdef APP-IOS || APP-HARMONY
export interface UniVerifyManager extends UniverifyManager {

}
// #endif

// #ifdef APP-ANDROID
export type UniVerifyManager = UniverifyManager
// #endif

export interface UniverifyManager {
	/**
	  * @description 预登录
	  * @uniPlatform {
	  *   "app": {
	  * 	  "android": {
	  *     	  "osVer": "5.0",
	  *  		  "uniVer": "√",
	  * 		  "unixVer": "3.99"
	  *  	  },
	  *       "ios": {
	  *           "osVer": "12.0",
	  *  		  "uniVer": "√",
	  * 		  "unixVer": "4.18"
	  *       },
	 *       "harmony": {
	 *       		"osVer": "5.0.0",
	 *  		  	"uniVer": "4.61",
	 * 		  		"unixVer": "4.61"
	 *       }
	  *   }
	  * }
	  */
	preLogin(options : UniVerifyManagerPreLoginOptions) : void
	/**
	  * @description 标准登录
	  * @uniPlatform {
	  *   "app": {
	  * 	  "android": {
	  *     	  "osVer": "5.0",
	  *  		  "uniVer": "√",
	  * 		  "unixVer": "3.99"
	  *  	  },
	  *       "ios": {
	  *           "osVer": "12.0",
	  *  		  "uniVer": "√",
	  * 		  "unixVer": "4.18"
	  *       },
	 *       "harmony": {
	 *       		"osVer": "5.0.0",
	 *  		  	"uniVer": "4.61",
	 * 		  		"unixVer": "4.61"
	 *       }
	  *   }
	  * }
	  */
	login(options : UniVerifyManagerLoginOptions) : void
	/**
	  * @description 自定义授权页登录
	  * @uniPlatform {
	  *   "app": {
	  * 	  "android": {
	  *     	  "osVer": "5.0",
	  *  		  "uniVer": "4.41",
	  * 		  "unixVer": "4.41"
	  *  	  },
	  *       "ios": {
	  *           "osVer": "12.0",
	  *  		  "uniVer": "4.41",
	  * 		  "unixVer": "4.41"
	  *       },
	 *       "harmony": {
	 *       		"osVer": "x",
	 *  		  	"uniVer": "x",
	 * 		  		"unixVer": "x"
	 *       }
	  *   }
	  * }
	  */
	customLogin(options : UniVerifyManagerCustomLoginOptions) : void
	/**
	  * @description 关闭授权页(仅支持标准登录)
	  * @uniPlatform {
	  *   "app": {
	  * 	  "android": {
	  *     	  "osVer": "5.0",
	  *  		  "uniVer": "√",
	  * 		  "unixVer": "3.99"
	  *  	  },
	  *       "ios": {
	  *           "osVer": "12.0",
	  *  		  "uniVer": "√",
	  * 		  "unixVer": "4.18"
	  *       },
	 *       "harmony": {
	 *       		"osVer": "5.0.0",
	 *  		  	"uniVer": "4.61",
	 * 		  		"unixVer": "4.61"
	 *       }
	  *   }
	  * }
	  */
	close() : void
	/**
	  * @description 预登录是否有效
	  * @uniPlatform {
	  *   "app": {
	  * 	  "android": {
	  *     	  "osVer": "5.0",
	  *  		  "uniVer": "√",
	  * 		  "unixVer": "3.99"
	  *  	  },
	  *       "ios": {
	  *           "osVer": "12.0",
	  *  		  "uniVer": "√",
	  * 		  "unixVer": "4.18"
	  *       },
	 *       "harmony": {
	 *       		"osVer": "5.0.0",
	 *  		  	"uniVer": "4.61",
	 * 		  		"unixVer": "4.61"
	 *       }
	  *   }
	  * }
	  */
	isPreLoginValid() : boolean
}

/**
 * 预登录参数
 */
export type UniVerifyManagerPreLoginOptions = {
	success ?: UniVerifyManagerPreLoginSuccessCallback,
	fail ?: UniVerifyManagerPreLoginFailCallback,
	complete ?: UniVerifyManagerPreLoginCompleteCallback
}

/**
 * 登录参数
 */
export type UniVerifyManagerLoginOptions = {
	/**
	  * @uniPlatform {
	  *   "app": {
	  * 	  "android": {
	  *     	  "osVer": "5.0",
	 *  		  	"uniVer": "4.51",
	 * 		  		"unixVer": "4.51"
	  *  	  },
	  *       "ios": {
	  *          "osVer": "12.0",
	 *  		  	"uniVer": "4.51",
	 * 		  		"unixVer": "4.51"
	  *       },
	 *       "harmony": {
	 *       		"osVer": "5.0.0",
	 *  		  	"uniVer": "4.61",
	 * 		  		"unixVer": "4.61"
	 *       }
	  *   }
	  * }
	 */
	uniVerifyStyle ?: UniVerifyManagerLoginStyle,
	/**
	 * @deprecated 已废弃，建议使用 uniVerifyStyle
	 */
	univerifyStyle ?: UniVerifyManagerLoginStyle,
	success ?: UniVerifyManagerLoginSuccessCallback,
	fail ?: UniVerifyManagerLoginFailCallback,
	complete ?: UniVerifyManagerLoginCompleteCallback
}

/**
 * 自定义登录页登录参数
 */
export type UniVerifyManagerCustomLoginOptions = {
	/**
	  * @description 号码栏，仅支持使用text组件
	  */
	numberTextElement : UniElement,
	/**
	  * @description 品牌露出，仅支持使用text组件
	  */
	sloganTextElement : UniElement,
	/**
	  * @description 登录按钮，仅支持使用button组件
	  */
	loginButtonElement : UniElement,
	/**
	  * @description 隐私确认，仅支持使用checkbox组件
	  */
	privacyCheckBoxElement : UniElement,
	/**
	  * @description 隐私标题，仅支持使用text组件
	  */
	privacyTextElement : UniElement,
	success ?: UniVerifyManagerLoginSuccessCallback,
	fail ?: UniVerifyManagerLoginFailCallback,
	complete ?: UniVerifyManagerLoginCompleteCallback
}

/**
 * 登录页样式
 */
export type UniVerifyManagerLoginStyle = {
	/**
	 * 是否全屏
	 */
	fullScreen ?: boolean,
	/**
	 * logo路径
	 */
	logoPath ?: string,
	/**
	 * 登录页背景色
	  * @uniPlatform {
	  *   "app": {
	  * 	  "android": {
	  *     	  "osVer": "5.0",
	  *  		  "uniVer": "√",
	  * 		  "unixVer": "3.99"
	  *  	  },
	  *       "ios": {
	  *           "osVer": "12.0",
	  *  		  "uniVer": "√",
	  * 		  "unixVer": "4.18"
	  *       },
	  *       "harmony": {
	  *         "osVer": "x",
	  *  		    "uniVer": "x",
	  * 		    "unixVer": "x"
	  *       }
	  *   }
	  * }
	 */
	backgroundColor ?: string,
	/**
	 * 登录按钮文字
	 */
	loginBtnText ?: string
}

export type UniVerifyManagerPreLoginSuccess = {
	/**
	 * 手机号（脱敏）
	 * @uniPlatform {
	 *   "app": {
	 * 	  "android": {
	 *     	  "osVer": "5.0",
	 *  		  "uniVer": "4.41",
	 * 		  "unixVer": "4.41"
	 *  	  },
	 *       "ios": {
	 *           "osVer": "12.0",
	 *  		  "uniVer": "4.41",
	 * 		  "unixVer": "4.41"
	 *       },
	 *       "harmony": {
	 *       		"osVer": "5.0.0",
	 *  		  	"uniVer": "4.61",
	 * 		  		"unixVer": "4.61"
	 *       }
	 *   }
	 * }
	 */
	number : string,
	/**
	 * 运营商slogan，如移动：中国移动提供认证服务，联通：认证服务由联通统一认证提供，电信：天翼账号提供认证服务
	 * @uniPlatform {
	 *   "app": {
	 * 	  "android": {
	 *     	  "osVer": "5.0",
	 *  		  "uniVer": "4.41",
	 * 		  "unixVer": "4.41"
	 *  	  },
	 *       "ios": {
	 *           "osVer": "12.0",
	 *  		  "uniVer": "4.41",
	 * 		  "unixVer": "4.41"
	 *       },
	 *       "harmony": {
	 *       		"osVer": "5.0.0",
	 *  		  	"uniVer": "4.61",
	 * 		  		"unixVer": "4.61"
	 *       }
	 *   }
	 * }
	 */
	slogan : string,
	/**
	 * 运营商隐私协议名称，如移动：中国移动认证服务条款，联通：联通统一认证服务条款，电信：天翼账号服务与隐私协议
	 * @uniPlatform {
	 *   "app": {
	 * 	  "android": {
	 *     	  "osVer": "5.0",
	 *  		  "uniVer": "4.41",
	 * 		  "unixVer": "4.41"
	 *  	  },
	 *       "ios": {
	 *           "osVer": "12.0",
	 *  		  "uniVer": "4.41",
	 * 		  "unixVer": "4.41"
	 *       },
	 *       "harmony": {
	 *       		"osVer": "x",
	 *  		  	"uniVer": "x",
	 * 		  		"unixVer": "x"
	 *       }
	 *   }
	 * }
	 */
	privacyName : string,
	/**
	 * 运营商隐私协议url地址
	 * @uniPlatform {
	 *   "app": {
	 * 	  "android": {
	 *     	  "osVer": "5.0",
	 *  		  "uniVer": "4.41",
	 * 		  "unixVer": "4.41"
	 *  	  },
	 *       "ios": {
	 *           "osVer": "12.0",
	 *  		  "uniVer": "4.41",
	 * 		  "unixVer": "4.41"
	 *       },
	 *       "harmony": {
	 *       		"osVer": "x",
	 *  		  	"uniVer": "x",
	 * 		  		"unixVer": "x"
	 *       }
	 *   }
	 * }
	 */
	privacyUrl : string
}
export type UniVerifyManagerPreLoginSuccessCallback = (res : UniVerifyManagerPreLoginSuccess) => void
export interface UniVerifyManagerPreLoginFail extends IUniError {
	errCode : UniVerifyManagerErrorCode
}
export type UniVerifyManagerPreLoginFailCallback = (err : UniVerifyManagerPreLoginFail) => void
export type UniVerifyManagerPreLoginComplete = any;
export type UniVerifyManagerPreLoginCompleteCallback = (res : UniVerifyManagerPreLoginComplete) => void

export type UniVerifyManagerLoginSuccess = {
	/**
	 * 登录授权唯一标识
	 */
	openId : string,
	/**
	 * token
	 */
	accessToken : string
}
export type UniVerifyManagerLoginSuccessCallback = (res : UniVerifyManagerLoginSuccess) => void
export interface UniVerifyManagerLoginFail extends IUniError {
	errCode : UniVerifyManagerErrorCode
}
export type UniVerifyManagerLoginFailCallback = (err : UniVerifyManagerLoginFail) => void
export type UniVerifyManagerLoginComplete = any;
export type UniVerifyManagerLoginCompleteCallback = (res : UniVerifyManagerLoginComplete) => void

/**
 * 错误码
 */

export type UniVerifyManagerErrorCode =
	/**
	 * 当前应用appid尚未开通uni一键登录
	 * @uniPlatform {
	 *   "app": {
	 * 	  "android": {
	 *     	  "osVer": "5.0",
	 *  		  "uniVer": "√",
	 * 		  "unixVer": "3.99"
	 *  	  },
	 *       "ios": {
	 *           "osVer": "12.0",
	 *  		  "uniVer": "√",
	 * 		  "unixVer": "4.18"
	 *       },
	 *       "harmony": {
	 *       		"osVer": "5.0.0",
	 *  		  	"uniVer": "4.61",
	 * 		  		"unixVer": "4.61"
	 *       }
	 *   }
	 * }
	 */
	1000 |
	/**
	 * 应用所有者账号信息异常，请检查账号一键登录服务是否正常
	 * @uniPlatform {
	 *   "app": {
	 * 	  "android": {
	 *     	  "osVer": "5.0",
	 *  		  "uniVer": "√",
	 * 		  "unixVer": "3.99"
	 *  	  },
	 *       "ios": {
	 *           "osVer": "12.0",
	 *  		  "uniVer": "√",
	 * 		  "unixVer": "4.18"
	 *       },
	 *       "harmony": {
	 *       		"osVer": "5.0.0",
	 *  		  	"uniVer": "4.61",
	 * 		  		"unixVer": "4.61"
	 *       }
	 *   }
	 * }
	 */
	1001 |
	/**
	 * 应用所有者账号信息异常，请检查账号余额是否充足
	 * @uniPlatform {
	 *   "app": {
	 * 	  "android": {
	 *     	  "osVer": "5.0",
	 *  		  "uniVer": "√",
	 * 		  "unixVer": "3.99"
	 *  	  },
	 *       "ios": {
	 *           "osVer": "12.0",
	 *  		  "uniVer": "√",
	 * 		  "unixVer": "4.18"
	 *       },
	 *       "harmony": {
	 *       		"osVer": "5.0.0",
	 *  		  	"uniVer": "4.61",
	 * 		  		"unixVer": "4.61"
	 *       }
	 *   }
	 * }
	 */
	1002 |
	/**
	 * uni一键登录应用不存在
	 * @uniPlatform {
	 *   "app": {
	 * 	  "android": {
	 *     	  "osVer": "5.0",
	 *  		  "uniVer": "√",
	 * 		  "unixVer": "3.99"
	 *  	  },
	 *       "ios": {
	 *           "osVer": "12.0",
	 *  		  "uniVer": "√",
	 * 		  "unixVer": "4.18"
	 *       },
	 *       "harmony": {
	 *       		"osVer": "5.0.0",
	 *  		  	"uniVer": "4.61",
	 * 		  		"unixVer": "4.61"
	 *       }
	 *   }
	 * }
	 */
	1004 |
	/**
	 * 参数异常
	 * @uniPlatform {
	 *   "app": {
	 * 	  "android": {
	 *     	  "osVer": "5.0",
	 *  		  "uniVer": "√",
	 * 		  "unixVer": "3.99"
	 *  	  },
	 *       "ios": {
	 *           "osVer": "12.0",
	 *  		  "uniVer": "√",
	 * 		  "unixVer": "4.18"
	 *       },
	 *       "harmony": {
	 *       		"osVer": "5.0.0",
	 *  		  	"uniVer": "4.61",
	 * 		  		"unixVer": "4.61"
	 *       }
	 *   }
	 * }
	 */
	4001 |
	/**
	 * 取消登录
	 * @uniPlatform {
	 *   "app": {
	 * 	  "android": {
	 *     	  "osVer": "5.0",
	 *  		  "uniVer": "√",
	 * 		  "unixVer": "4.51"
	 *  	  },
	 *       "ios": {
	 *           "osVer": "12.0",
	 *  		  "uniVer": "√",
	 * 		  "unixVer": "4.51"
	 *       },
	 *       "harmony": {
	 *       		"osVer": "5.0.0",
	 *  		  	"uniVer": "4.61",
	 * 		  		"unixVer": "4.61"
	 *       }
	 *   }
	 * }
	 */
	30001 |
	/**
	 * 其他错误
	 * @uniPlatform {
	 *   "app": {
	 * 	  "android": {
	 *     	  "osVer": "5.0",
	 *  		  "uniVer": "√",
	 * 		  "unixVer": "3.99"
	 *  	  },
	 *       "ios": {
	 *           "osVer": "12.0",
	 *  		  "uniVer": "√",
	 * 		  "unixVer": "4.18"
	 *       },
	 *       "harmony": {
	 *       		"osVer": "5.0.0",
	 *  		  	"uniVer": "4.61",
	 * 		  		"unixVer": "4.61"
	 *       }
	 *   }
	 * }
	 */
	30004 |
	/**
	 * 预登录失败
	 * @uniPlatform {
	 *   "app": {
	 * 	  "android": {
	 *     	  "osVer": "5.0",
	 *  		  "uniVer": "√",
	 * 		  "unixVer": "3.99"
	 *  	  },
	 *       "ios": {
	 *           "osVer": "12.0",
	 *  		  "uniVer": "√",
	 * 		  "unixVer": "4.18"
	 *       },
	 *       "harmony": {
	 *       		"osVer": "5.0.0",
	 *  		  	"uniVer": "4.61",
	 * 		  		"unixVer": "4.61"
	 *       }
	 *   }
	 * }
	 */
	30005 |
	/**
	 * 一键登录失败
	 * @uniPlatform {
	 *   "app": {
	 * 	  "android": {
	 *     	  "osVer": "5.0",
	 *  		  "uniVer": "√",
	 * 		  "unixVer": "3.99"
	 *  	  },
	 *       "ios": {
	 *           "osVer": "12.0",
	 *  		  "uniVer": "√",
	 * 		  "unixVer": "4.18"
	 *       },
	 *       "harmony": {
	 *       		"osVer": "5.0.0",
	 *  		  	"uniVer": "4.61",
	 * 		  		"unixVer": "4.61"
	 *       }
	 *   }
	 * }
	 */
	30006 |
	/**
	 * 预登录失效
	 * @uniPlatform {
	 *   "app": {
	 * 	  "android": {
	 *     	  "osVer": "5.0",
	 *  		  "uniVer": "√",
	 * 		  "unixVer": "3.99"
	 *  	  },
	 *       "ios": {
	 *           "osVer": "12.0",
	 *  		  "uniVer": "√",
	 * 		  "unixVer": "4.51"
	 *       },
	 *       "harmony": {
	 *       		"osVer": "5.0.0",
	 *  		  	"uniVer": "4.61",
	 * 		  		"unixVer": "4.61"
	 *       }
	 *   }
	 * }
	 */
	30007 |
	/**
	 * 上一个请求正在进行中，请稍后重试
	 * @uniPlatform {
	 *   "app": {
	 * 	  "android": {
	 *     	  "osVer": "5.0",
	 *  		  "uniVer": "√",
	 * 		  "unixVer": "3.99"
	 *  	  },
	 *       "ios": {
	 *           "osVer": "12.0",
	 *  		  "uniVer": "√",
	 * 		  "unixVer": "4.51"
	 *       },
	 *       "harmony": {
	 *       		"osVer": "5.0.0",
	 *  		  	"uniVer": "4.61",
	 * 		  		"unixVer": "4.61"
	 *       }
	 *   }
	 * }
	 */
	30008 |
	/**
	 * 自定义授权页面未同意隐私条款
	 * @uniPlatform {
	 *   "app": {
	 * 	  "android": {
	 *     	  "osVer": "5.0",
	 *  		  "uniVer": "4.41",
	 * 		  "unixVer": "4.41"
	 *  	  },
	 *       "ios": {
	 *           "osVer": "12.0",
	 *  		  "uniVer": "4.41",
	 * 		  "unixVer": "4.41"
	 *       },
	 *       "harmony": {
	 *       		"osVer": "x",
	 *  		  	"uniVer": "x",
	 * 		  		"unixVer": "x"
	 *       }
	 *   }
	 * }
	 */
	40001 |
	/**
	 * 自定义授权页不合规，请参考文档修改
	  * @uniPlatform {
	  *   "app": {
	  * 	  "android": {
	  *     	  "osVer": "5.0",
	  *  		  "uniVer": "4.41",
	  * 		  "unixVer": "4.41"
	  *  	  },
	  *       "ios": {
	  *           "osVer": "12.0",
	  *  		  "uniVer": "4.41",
	  * 		  "unixVer": "4.41"
	  *       },
	 *       "harmony": {
	 *       		"osVer": "x",
	 *  		  	"uniVer": "x",
	 * 		  		"unixVer": "x"
	 *       }
	  *   }
	  * }
	 */
	40002;
