/**
 * uni.shareWithSystem成功回调参数
 */
export type ShareWithSystemSuccess = {

}


export type ShareWithSystemFail = IShareWithSystemFail;

export interface IShareWithSystemFail extends IUniError {
	errCode : ShareWithSystemErrorCode
};
/**
 * 错误码
 */
export type ShareWithSystemErrorCode =
/**
 * 取消分享
 * @uniPlatform {
	*    "app": {
	*        "android": {
	*            "osVer": "5.0",
	*            "uniVer": "x",
	*            "unixVer": "4.33"
	*        },
	*        "ios": {
	*            "osVer": "12.0",
	*            "uniVer": "√",
	*            "unixVer": "4.33"
	*        },
	*        "harmony": {
	*            "osVer": "3.0",
	*            "uniVer": "x",
	*            "unixVer": "x"
	*        }
	*    },
	*    "web": {
	*        "uniVer": "x",
	*        "unixVer": "x"
	*    }
	* }
 */
1310600 |
/**
 * 分享内容不可以为空
 * @uniPlatform {
	*    "app": {
	*        "android": {
	*            "osVer": "5.0",
	*            "uniVer": "√",
	*            "unixVer": "4.33"
	*        },
	*        "ios": {
	*            "osVer": "12.0",
	*            "uniVer": "√",
	*            "unixVer": "4.33"
	*        },
	*        "harmony": {
	*            "osVer": "3.0",
	*            "uniVer": "x",
	*            "unixVer": "x"
	*        }
	*    },
	*    "web": {
	*        "uniVer": "x",
	*        "unixVer": "x"
	*    }
	* }
 */
1310601 |
/**
 * 已经成功调用系统分享接口，系统分享出错
 * @uniPlatform {
	*    "app": {
	*        "android": {
	*            "osVer": "5.0",
	*            "uniVer": "√",
	*            "unixVer": "4.33"
	*        },
	*        "ios": {
	*            "osVer": "12.0",
	*            "uniVer": "√",
	*            "unixVer": "4.33"
	*        },
	*        "harmony": {
	*            "osVer": "3.0",
	*            "uniVer": "x",
	*            "unixVer": "x"
	*        }
	*    },
	*    "web": {
	*        "uniVer": "x",
	*        "unixVer": "x"
	*    }
	* }
 */
1310602 |
/**
 * 图片路径无效
 * @uniPlatform {
	*    "app": {
	*        "android": {
	*            "osVer": "5.0",
	*            "uniVer": "√",
	*            "unixVer": "4.33"
	*        },
	*        "ios": {
	*            "osVer": "12.0",
	*            "uniVer": "√",
	*            "unixVer": "4.33"
	*        },
	*        "harmony": {
	*            "osVer": "3.0",
	*            "uniVer": "x",
	*            "unixVer": "x"
	*        }
	*    },
	*    "web": {
	*        "uniVer": "x",
	*        "unixVer": "x"
	*    }
	* }
 */
1310603 |
/**
 * 无效的链接
 * @uniPlatform {
	*    "app": {
	*        "android": {
	*            "osVer": "5.0",
	*            "uniVer": "√",
	*            "unixVer": "4.33"
	*        },
	*        "ios": {
	*            "osVer": "12.0",
	*            "uniVer": "√",
	*            "unixVer": "4.33"
	*        },
	*        "harmony": {
	*            "osVer": "3.0",
	*            "uniVer": "x",
	*            "unixVer": "x"
	*        }
	*    },
	*    "web": {
	*        "uniVer": "x",
	*        "unixVer": "x"
	*    }
	* }
 */
1310604 |
/**
 * video 路径无效
 * @uniPlatform {
	*    "app": {
	*        "android": {
	*            "osVer": "5.0",
	*            "uniVer": "√",
	*            "unixVer": "4.33"
	*        },
	*        "ios": {
	*            "osVer": "12.0",
	*            "uniVer": "√",
	*            "unixVer": "4.33"
	*        },
	*        "harmony": {
	*            "osVer": "3.0",
	*            "uniVer": "x",
	*            "unixVer": "x"
	*        }
	*    },
	*    "web": {
	*        "uniVer": "x",
	*        "unixVer": "x"
	*    }
	* }
 */
1310605 |
/**
 * file 文件不存在
 * @uniPlatform {
	*    "app": {
	*        "android": {
	*            "osVer": "5.0",
	*            "uniVer": "√",
	*            "unixVer": "4.33"
	*        },
	*        "ios": {
	*            "osVer": "12.0",
	*            "uniVer": "√",
	*            "unixVer": "4.33"
	*        },
	*        "harmony": {
	*            "osVer": "3.0",
	*            "uniVer": "x",
	*            "unixVer": "x"
	*        }
	*    },
	*    "web": {
	*        "uniVer": "x",
	*        "unixVer": "x"
	*    }
	* }
 */
1310606 |
/**
 * audio 路径无效
 * @uniPlatform {
	*    "app": {
	*        "android": {
	*            "osVer": "5.0",
	*            "uniVer": "√",
	*            "unixVer": "4.33"
	*        },
	*        "ios": {
	*            "osVer": "12.0",
	*            "uniVer": "√",
	*            "unixVer": "4.33"
	*        },
	*        "harmony": {
	*            "osVer": "3.0",
	*            "uniVer": "x",
	*            "unixVer": "x"
	*        }
	*    },
	*    "web": {
	*        "uniVer": "x",
	*        "unixVer": "x"
	*    }
	* }
 */
1310607;

/**
 * uni.shareWithSystem成功回调函数定义
 */
export type ShareWithSystemSuccessCallback = (res: ShareWithSystemSuccess) => void
/**
 * uni.shareWithSystem失败回调函数定义
 */
export type ShareWithSystemFailCallback = (res: ShareWithSystemFail) => void
/**
 * uni.shareWithSystem完成回调函数定义
 */
export type ShareWithSystemCallback = (res: any) => void
/**
 * uni.shareWithSystem参数定义
 */
export type ShareWithSystemOptions = {
    /**
     * 分享类型,默认为text。
     * @uniPlatform {
     *     "app": {
     *         "android": {
     *             "osVer": "5.0",
     *             "uniVer": "√",
     *             "unixVer": "4.33"
     *         },
     *         "ios": {
     *             "osVer": "12.0",
     *             "uniVer": "√",
     *             "unixVer": "x"
     *         },
     *         "harmony": {
     *             "osVer": "3.0",
     *             "uniVer": "x",
     *             "unixVer": "x"
     *         }
     *     },
     *     "web": {
     *         "uniVer": "x",
     *         "unixVer": "x"
     *     }
     * }
     */
    type?:
	/**
	 * text类型
	 * @uniPlatform {
	 *     "app": {
	 *         "android": {
	 *             "osVer": "5.0",
	 *             "uniVer": "√",
	 *             "unixVer": "4.33"
	 *         },
	 *         "ios": {
	 *             "osVer": "12.0",
	 *             "uniVer": "√",
	 *             "unixVer": "x"
	 *         },
	 *         "harmony": {
	 *             "osVer": "3.0",
	 *             "uniVer": "x",
	 *             "unixVer": "x"
	 *         }
	 *     },
	 *     "web": {
	 *         "uniVer": "x",
	 *         "unixVer": "x"
	 *     }
	 * }
	 */
	'text' |
	 /**
	  * image类型
	  * @uniPlatform {
	  *     "app": {
	  *         "android": {
	  *             "osVer": "5.0",
	  *             "uniVer": "√",
	  *             "unixVer": "4.33"
	  *         },
	  *         "ios": {
	  *             "osVer": "12.0",
	  *             "uniVer": "√",
	  *             "unixVer": "x"
	  *         },
	  *         "harmony": {
	  *             "osVer": "3.0",
	  *             "uniVer": "x",
	  *             "unixVer": "x"
	  *         }
	  *     },
	  *     "web": {
	  *         "uniVer": "x",
	  *         "unixVer": "x"
	  *     }
	  * }
	  */
	 'image' |
	 /**
	  * video类型
	  * @uniPlatform {
	  *     "app": {
	  *         "android": {
	  *             "osVer": "5.0",
	  *             "uniVer": "√",
	  *             "unixVer": "4.33"
	  *         },
	  *         "ios": {
	  *             "osVer": "12.0",
	  *             "uniVer": "√",
	  *             "unixVer": "x"
	  *         },
	  *         "harmony": {
	  *             "osVer": "3.0",
	  *             "uniVer": "x",
	  *             "unixVer": "x"
	  *         }
	  *     },
	  *     "web": {
	  *         "uniVer": "x",
	  *         "unixVer": "x"
	  *     }
	  * }
	  */
	 'video' |
	 /**
	  * audio类型
	  * @uniPlatform {
	  *     "app": {
	  *         "android": {
	  *             "osVer": "5.0",
	  *             "uniVer": "√",
	  *             "unixVer": "4.33"
	  *         },
	  *         "ios": {
	  *             "osVer": "12.0",
	  *             "uniVer": "√",
	  *             "unixVer": "x"
	  *         },
	  *         "harmony": {
	  *             "osVer": "3.0",
	  *             "uniVer": "x",
	  *             "unixVer": "x"
	  *         }
	  *     },
	  *     "web": {
	  *         "uniVer": "x",
	  *         "unixVer": "x"
	  *     }
	  * }
	  */
	 'audio' |
	 /**
	  * file类型
	  * @uniPlatform {
	  *     "app": {
	  *         "android": {
	  *             "osVer": "5.0",
	  *             "uniVer": "√",
	  *             "unixVer": "4.33"
	  *         },
	  *         "ios": {
	  *             "osVer": "12.0",
	  *             "uniVer": "√",
	  *             "unixVer": "x"
	  *         },
	  *         "harmony": {
	  *             "osVer": "3.0",
	  *             "uniVer": "x",
	  *             "unixVer": "x"
	  *         }
	  *     },
	  *     "web": {
	  *         "uniVer": "x",
	  *         "unixVer": "x"
	  *     }
	  * }
	  */
	 'file',
    /**
     * 分享的文字内容
     * @uniPlatform {
     *     "app": {
     *         "android": {
     *             "osVer": "5.0",
     *             "uniVer": "√",
     *             "unixVer": "4.33"
     *         },
     *         "ios": {
     *             "osVer": "12.0",
     *             "uniVer": "√",
     *             "unixVer": "4.33"
     *         },
     *         "harmony": {
     *             "osVer": "3.0",
     *             "uniVer": "x",
     *             "unixVer": "x"
     *         }
     *     },
     *     "web": {
     *         "uniVer": "x",
     *         "unixVer": "x"
     *     }
     * }
     */
    summary?: string,
    /**
     * 分享链接
     * @uniPlatform {
     *     "app": {
     *         "android": {
     *             "osVer": "5.0",
     *             "uniVer": "√",
     *             "unixVer": "4.33"
     *         },
     *         "ios": {
     *             "osVer": "12.0",
     *             "uniVer": "√",
     *             "unixVer": "4.33"
     *         },
     *         "harmony": {
     *             "osVer": "3.0",
     *             "uniVer": "x",
     *             "unixVer": "x"
     *         }
     *     },
     *     "web": {
     *         "uniVer": "x",
     *         "unixVer": "x"
     *     }
     * }
     */
    href?: string,
    /**
     * 分享单个图片，仅支持本地路径
     * @uniPlatform {
     *     "app": {
     *         "android": {
     *             "osVer": "5.0",
     *             "uniVer": "√",
     *             "unixVer": "4.33"
     *         },
     *         "ios": {
     *             "osVer": "12.0",
     *             "uniVer": "√",
     *             "unixVer": "4.33"
     *         },
     *         "harmony": {
     *             "osVer": "3.0",
     *             "uniVer": "x",
     *             "unixVer": "x"
     *         }
     *     },
     *     "web": {
     *         "uniVer": "x",
     *         "unixVer": "x"
     *     }
     * }
     */
    imageUrl?: string,
	/**
	 * 分享图片，仅支持本地路径
     * @uniPlatform {
     *     "app": {
     *         "android": {
     *             "osVer": "5.0",
     *             "uniVer": "√",
     *             "unixVer": "4.33"
     *         },
     *         "ios": {
     *             "osVer": "12.0",
     *             "uniVer": "√",
     *             "unixVer": "4.33"
     *         },
     *         "harmony": {
     *             "osVer": "3.0",
     *             "uniVer": "x",
     *             "unixVer": "x"
     *         }
     *     },
     *     "web": {
     *         "uniVer": "x",
     *         "unixVer": "x"
     *     }
     * }
	 */
	imagePaths?: Array<string>,
	/**
	 * 分享video，仅支持本地路径
	 * @uniPlatform {
	 *     "app": {
	 *         "android": {
	 *             "osVer": "5.0",
	 *             "uniVer": "√",
	 *             "unixVer": "4.33"
	 *         },
	 *         "ios": {
	 *             "osVer": "12.0",
	 *             "uniVer": "√",
	 *             "unixVer": "4.33"
	 *         },
	 *         "harmony": {
	 *             "osVer": "3.0",
	 *             "uniVer": "x",
	 *             "unixVer": "x"
	 *         }
	 *     },
	 *     "web": {
	 *         "uniVer": "x",
	 *         "unixVer": "x"
	 *     }
	 * }
	 */

	videoPaths?: Array<string>,
	/**
	 * 分享audio，仅支持本地路径
	 * @uniPlatform {
	 *     "app": {
	 *         "android": {
	 *             "osVer": "5.0",
	 *             "uniVer": "√",
	 *             "unixVer": "4.33"
	 *         },
	 *         "ios": {
	 *             "osVer": "12.0",
	 *             "uniVer": "√",
	 *             "unixVer": "4.33"
	 *         },
	 *         "harmony": {
	 *             "osVer": "3.0",
	 *             "uniVer": "x",
	 *             "unixVer": "x"
	 *         }
	 *     },
	 *     "web": {
	 *         "uniVer": "x",
	 *         "unixVer": "x"
	 *     }
	 * }
	 */
	audioPaths?: Array<string>,
	/**
	 * 分享文件，仅支持本地路径
	 * @uniPlatform {
	 *     "app": {
	 *         "android": {
	 *             "osVer": "5.0",
	 *             "uniVer": "√",
	 *             "unixVer": "4.33"
	 *         },
	 *         "ios": {
	 *             "osVer": "12.0",
	 *             "uniVer": "√",
	 *             "unixVer": "4.33"
	 *         },
	 *         "harmony": {
	 *             "osVer": "3.0",
	 *             "uniVer": "x",
	 *             "unixVer": "x"
	 *         }
	 *     },
	 *     "web": {
	 *         "uniVer": "x",
	 *         "unixVer": "x"
	 *     }
	 * }
	 */

	filePaths?: Array<string>,
    /**
     * 接口调用成功的回调函数
     * @uniPlatform {
     *     "app": {
     *         "android": {
     *             "osVer": "5.0",
     *             "uniVer": "√",
     *             "unixVer": "4.33"
     *         },
     *         "ios": {
     *             "osVer": "12.0",
     *             "uniVer": "√",
     *             "unixVer": "4.33"
     *         },
     *         "harmony": {
     *             "osVer": "3.0",
     *             "uniVer": "x",
     *             "unixVer": "x"
     *         }
     *     },
     *     "web": {
     *         "uniVer": "x",
     *         "unixVer": "x"
     *     }
     * }
     */
    success?: ShareWithSystemSuccessCallback | null,
    /**
     * 接口调用失败的回调函数
     * @uniPlatform {
     *     "app": {
     *         "android": {
     *             "osVer": "5.0",
     *             "uniVer": "√",
     *             "unixVer": "4.33"
     *         },
     *         "ios": {
     *             "osVer": "12.0",
     *             "uniVer": "√",
     *             "unixVer": "4.33"
     *         },
     *         "harmony": {
     *             "osVer": "3.0",
     *             "uniVer": "x",
     *             "unixVer": "x"
     *         }
     *     },
     *     "web": {
     *         "uniVer": "x",
     *         "unixVer": "x"
     *     }
     * }
     */
    fail?: ShareWithSystemFailCallback | null,
    /**
     * 接口调用结束的回调函数（调用成功、失败都会执行）
     * @uniPlatform {
     *     "app": {
     *         "android": {
     *             "osVer": "5.0",
     *             "uniVer": "√",
     *             "unixVer": "4.33"
     *         },
     *         "ios": {
     *             "osVer": "12.0",
     *             "uniVer": "√",
     *             "unixVer": "4.33"
     *         },
     *         "harmony": {
     *             "osVer": "3.0",
     *             "uniVer": "x",
     *             "unixVer": "x"
     *         }
     *     },
     *     "web": {
     *         "uniVer": "x",
     *         "unixVer": "x"
     *     }
     * }
     */
    complete?: ShareWithSystemCallback | null
}

export type ShareWithSystem = (options: ShareWithSystemOptions) => void

export interface Uni {
    /**
     * 使用系统分享。
     *
     * @param {ShareWithSystemOptions} options
     * @uniPlatform {
     *     "app": {
     *         "android": {
     *             "osVer": "5.0",
     *             "uniVer": "√",
     *             "unixVer": "4.33"
     *         },
     *         "ios": {
     *             "osVer": "12.0",
     *             "uniVer": "√",
     *             "unixVer": "4.33"
     *         },
     *         "harmony": {
     *             "osVer": "3.0",
     *             "uniVer": "4.31",
     *             "unixVer": "4.61"
     *         }
     *     },
     *     "web": {
     *         "uniVer": "x",
     *         "unixVer": "x"
     *     }
     * }
     */
    shareWithSystem(options: ShareWithSystemOptions): void,
}
