export interface Uni {
  /**
   * 登录
   *
   * @tutorial https://uniapp.dcloud.net.cn/api/plugins/login.html#login
   * @tutorial-uni-app https://uniapp.dcloud.net.cn/api/plugins/login.html#login
   *
   * @uniPlatform {
   *   "app": {
   *     "android": {
   *       "osVer": "5.0",
   *       "uniVer": "√",
   *       "unixVer": "x"
   *     },
   *     "ios": {
   *       "osVer": "12.0",
   *       "uniVer": "√",
   *       "unixVer": "x"
   *     },
   *     "harmony": {
   *       "osVer": "3.0",
   *       "uniVer": "4.31",
   *       "unixVer": "4.61"
   *     }
   *   },
   *   "mp": {
   *     "360": {
   *       "hostVer": "√",
   *       "uniVer": "√",
   *       "unixVer": "x"
   *     },
   *     "weixin": {
   *       "hostVer": "2.3.1",
   *       "uniVer": "√",
   *       "unixVer": "4.41"
   *     },
   *     "alipay": {
   *       "hostVer": "√",
   *       "uniVer": "√",
   *       "unixVer": "x"
   *     },
   *     "baidu": {
   *       "hostVer": "√",
   *       "uniVer": "√",
   *       "unixVer": "x"
   *     },
   *     "toutiao": {
   *       "hostVer": "√",
   *       "uniVer": "√",
   *       "unixVer": "x"
   *     },
   *     "lark": {
   *       "hostVer": "√",
   *       "uniVer": "√",
   *       "unixVer": "x"
   *     },
   *     "qq": {
   *       "hostVer": "√",
   *       "uniVer": "√",
   *       "unixVer": "x"
   *     },
   *     "kuaishou": {
   *       "hostVer": "√",
   *       "uniVer": "√",
   *       "unixVer": "x"
   *     },
   *     "jd": {
   *       "hostVer": "√",
   *       "uniVer": "√",
   *       "unixVer": "x"
   *     }
   *   },
   *   "quickapp": {
   *     "uniVer": "√",
   *     "unixVer": "√"
   *   },
   *   "web": {
   *     "uniVer": "x",
   *     "unixVer": "x"
   *   }
   * }
     * @tutorial_weixin https://developers.weixin.qq.com/miniprogram/dev/api/open-api/login/wx.login.html
     */
  login(options: LoginOptions): void;
  /**
   * 获取用户信息
   *
   * @tutorial https://uniapp.dcloud.net.cn/api/plugins/login.html#getuserinfo
   * @tutorial-uni-app https://uniapp.dcloud.net.cn/api/plugins/login.html#getuserinfo
   *
   * @uniPlatform {
   *   "app": {
   *     "android": {
   *       "osVer": "5.0",
   *       "uniVer": "√",
   *       "unixVer": "x"
   *     },
   *     "ios": {
   *       "osVer": "12.0",
   *       "uniVer": "√",
   *       "unixVer": "x"
   *     },
   *     "harmony": {
   *       "osVer": "3.0",
   *       "uniVer": "4.31",
   *       "unixVer": "4.61"
   *     }
   *   },
   *   "mp": {
   *     "360": {
   *       "hostVer": "√",
   *       "uniVer": "√",
   *       "unixVer": "x"
   *     },
   *     "weixin": {
   *       "hostVer": "2.3.1",
   *       "uniVer": "√",
   *       "unixVer": "4.41"
   *     },
   *     "alipay": {
   *       "hostVer": "√",
   *       "uniVer": "√",
   *       "unixVer": "x"
   *     },
   *     "baidu": {
   *       "hostVer": "√",
   *       "uniVer": "√",
   *       "unixVer": "x"
   *     },
   *     "toutiao": {
   *       "hostVer": "√",
   *       "uniVer": "√",
   *       "unixVer": "x"
   *     },
   *     "lark": {
   *       "hostVer": "√",
   *       "uniVer": "√",
   *       "unixVer": "x"
   *     },
   *     "qq": {
   *       "hostVer": "√",
   *       "uniVer": "√",
   *       "unixVer": "x"
   *     },
   *     "kuaishou": {
   *       "hostVer": "√",
   *       "uniVer": "√",
   *       "unixVer": "x"
   *     },
   *     "jd": {
   *       "hostVer": "√",
   *       "uniVer": "√",
   *       "unixVer": "x"
   *     }
   *   },
   *   "quickapp": {
   *     "uniVer": "√",
   *     "unixVer": "√"
   *   },
   *   "web": {
   *     "uniVer": "x",
   *     "unixVer": "x"
   *   }
   * }
     * @tutorial_weixin https://developers.weixin.qq.com/miniprogram/dev/api/open-api/user-info/wx.getUserInfo.html
     */
  getUserInfo(options: GetUserInfoOptions): void;
}
export interface UniOAuthProvider extends UniProvider {
  login(options: LoginOptions): void;
  getUserInfo(options: GetUserInfoOptions): void;
}
export type Login = (options: LoginOptions) => void;

export type AppleLoginAppleInfo = {
  /**
   * 应用程序用来与服务器交互的令牌
   */
  authorizationCode?: string | null,
  /**
   * 返回身份的全名
   */
  fullName?: any | null,
  /**
   * 一个JSON Web令牌(JWT)，可以安全地将用户信息传递给应用程序
   */
  identityToken?: string | null,
  /**
   * 指示用户是否为真人
   */
  realUserStatus?: number | null,
  /**
   * 验证用户的标识符
   */
  user?: string | null
};
export type LoginSuccess = {
  /**
   * 描述信息
     * @uniPlatform {
     *   "mp": {
     *     "weixin": {
     *       "hostVer": "√",
     *       "uniVer": "√",
     *       "unixVer": "4.41"
     *     },
     *     "alipay": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "baidu": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "toutiao": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "lark": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "qq": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "kuaishou": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "jd": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     }
     *   }
     * }
     */
  errMsg: string,
  /**
   * 登录服务商提供的登录信息，服务商不同返回的结果不完全相同
     * @uniPlatform {
     *   "mp": {
     *     "weixin": {
     *       "hostVer": "√",
     *       "uniVer": "√",
     *       "unixVer": "4.41"
     *     },
     *     "alipay": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "baidu": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "toutiao": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "lark": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "qq": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "kuaishou": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "jd": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     }
     *   }
     * }
     */
  authResult: any,
  /**
   * 小程序用户临时登录凭证
   * @uniPlatform {
   *   "mp": {
   *     "weixin": {
   *       "hostVer": "√",
   *       "uniVer": "√",
   *       "unixVer": "4.41"
   *     },
   *     "alipay": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "baidu": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "toutiao": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "lark": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "qq": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "kuaishou": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "jd": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     }
   *   }
   * }
   */
  code: string,
  /**
   * 头条小程序当前设备标识
   * @uniPlatform {
   *   "mp": {
   *     "weixin": {
   *       "hostVer": "√",
   *       "uniVer": "√",
   *       "unixVer": "4.41"
   *     },
   *     "alipay": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "baidu": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "toutiao": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "lark": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "qq": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "kuaishou": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "jd": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     }
   *   }
   * }
   */
  anonymousCode?: string | null,
  /**
   * 支付宝小程序授权码
   * @uniPlatform {
   *   "mp": {
   *     "weixin": {
   *       "hostVer": "√",
   *       "uniVer": "√",
   *       "unixVer": "4.41"
   *     },
   *     "alipay": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "baidu": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "toutiao": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "lark": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "qq": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "kuaishou": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "jd": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     }
   *   }
   * }
   */
  authCode?: string | null,
  /**
   * 支付宝小程序登录失败的授权类型，key是授权失败的 scope，value 是对应的错误码
   * @uniPlatform {
   *   "mp": {
   *     "weixin": {
   *       "hostVer": "√",
   *       "uniVer": "√",
   *       "unixVer": "4.41"
   *     },
   *     "alipay": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "baidu": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "toutiao": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "lark": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "qq": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "kuaishou": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "jd": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     }
   *   }
   * }
   */
  authErrorScope?: any | null,
  /**
   * 支付宝小程序登录成功的授权 scope
   * @uniPlatform {
   *   "mp": {
   *     "weixin": {
   *       "hostVer": "√",
   *       "uniVer": "√",
   *       "unixVer": "4.41"
   *     },
   *     "alipay": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "baidu": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "toutiao": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "lark": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "qq": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "kuaishou": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "jd": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     }
   *   }
   * }
   */
  authSucessScope?: (string[]) | null,
  /**
   * 苹果登录成功返回的信息
   * @uniPlatform {
   *   "mp": {
   *     "weixin": {
   *       "hostVer": "√",
   *       "uniVer": "√",
   *       "unixVer": "4.41"
   *     },
   *     "alipay": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "baidu": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "toutiao": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "lark": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "qq": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "kuaishou": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "jd": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     }
   *   }
   * }
   */
  appleInfo?: AppleLoginAppleInfo | null
};
export type LoginSuccessCallback = (result: LoginSuccess) => void;
export type LoginFail = IUniError;
export type LoginFailCallback = (result: LoginFail) => void;
export type LoginComplete = any;
export type LoginCompleteCallback = (result: LoginComplete) => void;
export type LoginOptions = {
  /**
   * 授权登录服务提供商，通过uni.getProvider获取，如果不设置则弹出分享列表选择界面
   *
   * @uniPlatform {
   *  "app": {
   *    "android": {
   *        "osVer": "5.0",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *      },
   *      "ios": {
   *          "osVer": "12.0",
   *          "uniVer": "√",
   *          "unixVer": "x"
   *      },
   *    "harmony": {
   *      "osVer": "3.0",
   *      "uniVer": "4.27",
   *      "unixVer": "4.61"
   *    }
   *  },
   *  "mp": {
   *    "weixin": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "alipay": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "baidu": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "toutiao": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "lark": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "qq": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "kuaishou": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "jd": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "360": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    }
   *  },
   *  "quickapp": {
   *      "uniVer": "x",
   *      "unixVer": "x"
   *  },
   *  "web": {
   *      "uniVer": "x",
   *      "unixVer": "x"
   *  }
   * }
   */
  provider?:
  /**
   * 微信登录
   */
  'weixin' |
  /**
   * QQ登录
   */
  'qq' |
  /**
   * 新浪微博登录
   */
  'sinaweibo' |
  /**
   * 小米登录
   */
  'xiaomi' |
  /**
   * Apple登录
   */
  'apple' |
  /**
   * 一键登录
   */
  'univerify' |
  /**
   * 华为 HarmonyOS Next 华为账号登录
   */
  'huawei' | null,
  /**
   * 授权类型，默认 auth_base。支持 auth_base（静默授权）/ auth_user（主动授权） / auth_zhima（芝麻信用）
   *
   * @uniPlatform {
   *  "mp": {
   *    "alipay": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *    }
   *  }
   * }
   */
  scopes?: any | null,
  /**
   * 超时时间，单位 ms
   * @uniPlatform {
   *  "mp": {
   *    "weixin": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "2.35"
   *    },
   *    "baidu": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *    },
   *    "jd": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *    }
   *  }
   * }
   */
  timeout?: number | null,
  /**
   * 一键登录页面样式
   *
   * @uniPlatform {
   *  "app": {
   *    "android": {
   *        "osVer": "5.0",
   *        "uniVer": "3.0.0",
   *        "unixVer": "x"
   *      },
   *      "ios": {
   *          "osVer": "12.0",
   *          "uniVer": "3.0.0",
   *          "unixVer": "x"
   *      },
   *    "harmony": {
   *      "osVer": "x",
   *      "uniVer": "x",
   *      "unixVer": "x"
   *    }
   *  },
   * "web": {
   *    "uniVer": "x",
   *    "unixVer": "x"
   *  }
   * }
   */
  univerifyStyle?: UniverifyStyle | null,
  /**
   * 微信登录仅请求授权认证
   *
   * @uniPlatform {
   *  "app": {
   *    "android": {
   *        "osVer": "5.0",
   *        "uniVer": "3.2.6",
   *        "unixVer": "x"
   *      },
   *      "ios": {
   *          "osVer": "12.0",
   *          "uniVer": "3.2.6",
   *          "unixVer": "x"
   *      },
   *    "harmony": {
   *      "osVer": "x",
   *      "uniVer": "x",
   *      "unixVer": "x"
   *    }
   *  },
   * "web": {
   *    "uniVer": "x",
   *    "unixVer": "x"
   *  }
   * }
   */
  onlyAuthorize?: boolean | null,
  /**
   * 接口调用成功的回调函数
   * @uniPlatform {
   *   "mp": {
   *     "weixin": {
   *       "hostVer": "√",
   *       "uniVer": "√",
   *       "unixVer": "4.41"
   *     },
   *     "alipay": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "baidu": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "toutiao": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "lark": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "qq": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "kuaishou": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "jd": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     }
   *   }
   * }
   */
  success?: LoginSuccessCallback | null,
  /**
   * 接口调用失败的回调函数
   * @uniPlatform {
   *   "mp": {
   *     "weixin": {
   *       "hostVer": "√",
   *       "uniVer": "√",
   *       "unixVer": "4.41"
   *     },
   *     "alipay": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "baidu": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "toutiao": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "lark": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "qq": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "kuaishou": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "jd": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     }
   *   }
   * }
   */
  fail?: LoginFailCallback | null,
  /**
   * 接口调用结束的回调函数（调用成功、失败都会执行）
   * @uniPlatform {
   *   "mp": {
   *     "weixin": {
   *       "hostVer": "√",
   *       "uniVer": "√",
   *       "unixVer": "4.41"
   *     },
   *     "alipay": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "baidu": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "toutiao": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "lark": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "qq": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "kuaishou": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "jd": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     }
   *   }
   * }
   */
  complete?: LoginCompleteCallback | null
};

export type UniverifyIconStyles = {
  /**
   * 图标地址
   *
   * 仅支持本地路径，默认为应用图标。
   */
  path: string,
  /**
   * 图标宽度
   *
   * 格式为“XXpx"，默认值为"60px"。
   */
  width?: string | null,
  /**
   * 图标高度
   *
   * 格式为“XXpx"，默认值为"60px"。
   */
  height?: string | null
};
export type UniverifyPhoneNumStyles = {
  /**
   * 字体颜色
   *
   * 格式为"#RRGGBB"，默认值为"#000000"。
   */
  color?: string | null,
  /**
   * 字体大小
   *
   * 格式为“XXpx"，默认值为"18px"。注意：字体加粗显示。
   */
  fontSize?: string | null
};
export type UniverifySloganStyles = {
  /**
   * 字体颜色
   *
   * 格式为"#RRGGBB"，默认值为"#8a8b90"。
   */
  color?: string | null,
  /**
   * 字体大小
   *
   * 格式为“XXpx"，默认值为"12px"。
   */
  fontSize?: string | null
};
export type UniverifyAuthButtonStyles = {
  /**
   * 正常状态按钮颜色
   *
   * 格式为"#RRGGBB"，默认值为"#3479f5"。
   */
  normalColor?: string | null,
  /**
   * 按下状态按钮颜色
   *
   * 格式为"#RRGGBB"，默认值为"#2861c5"。
   */
  highlightColor?: string | null,
  /**
   * 不可点击状态按钮颜色
   *
   * 格式为"#RRGGBB"，默认值为"#73aaf5"。 注意：仅iOS平台支持。
   */
  disabledColor?: string | null,
  /**
   * 按钮宽度
   *
   * 格式为“XXpx"，默认值为自适应，距离屏幕左右"32px"。
   */
  width?: string | null,
  /**
   * 按钮高度
   *
   * 格式为“XXpx"，默认值为"94px"。
   */
  height?: string | null,
  /**
   * 按钮上文字颜色
   *
   * 格式为"#RRGGBB"，默认值为"#ffffff"。
   */
  textColor?: string | null,
  /**
   * 按钮上文字内容
   *
   * 默认值为"本机号码一键登录"。
   */
  title?: string | null,
  /**
   * 授权按钮圆角
   *
   * 格式为“XXpx"，默认值："24px" （按钮高度的一半）
   */
  borderRadius?: string | null
};
export type UniverifyOtherButtonStyles = {
  /**
   * 是否显示其它按钮
   *
   * 可取值： true - 显示其它按钮；false - 不显示其它按钮。 默认值为true。
   * @type boolean
   */
  visible?: boolean | null,
  /**
   * 正常状态按钮颜色
   *
   * 格式为"#RRGGBB"，默认值为"#f8f8f8"。
   */
  normalColor?: string | null,
  /**
   * 按下状态按钮颜色
   *
   * 格式为"#RRGGBB"，默认值为"#dedede"。
   */
  highlightColor?: string | null,
  /**
   * 按钮宽度
   *
   * 格式为“XXpx"，默认值为自适应，距离屏幕左右"32px"。
   */
  width?: string | null,
  /**
   * 按钮高度
   *
   * 格式为“XXpx"，默认值为"94px"。
   */
  height?: string | null,
  /**
   * 按钮上文字颜色
   *
   * 格式为"#RRGGBB"，默认值为"#000000"。
   */
  textColor?: string | null,
  /**
   * 按钮上文字内容
   *
   * 默认值为"本机号码一键登录"。
   */
  title?: string | null,
  /**
   * 按钮边框宽度
   *
   * 格式为“XXpx"，默认值为"1px"。 注意：仅iOS平台支持。
   */
  borderWidth?: string | null,
  /**
   * 按钮边框颜色
   *
   * 格式为"#RRGGBB"，默认值为"#c5c5c5"。 注意：仅iOS平台支持。
   */
  borderColor?: string | null,
  /**
   * 其他登录按钮圆角
   *
   * 格式为“XXpx"，默认值："24px" （按钮高度的一半）
   */
  borderRadius?: string | null
};
export type UniverifyPrivacyItemStyles = {
  /**
   * 链接地址
   *
   * http/https开头的协议链接地址。
   */
  url: string,
  /**
   * 协议链接文字
   */
  title: string
};
export type UniverifyPrivacyTermsStyles = {
  /**
   * 默认是否勾选同意协议选择框
   *
   * ture表示勾选，false表示不勾选。默认值为true。
   *                     HBuilderX3.1.0+版本新增支持。
   * @type boolean
   */
  defaultCheckBoxState?: boolean | null,
  /**
   * 普通文字颜色
   *
   * 格式为"#RRGGBB"，默认值为"#8a8b90"。
   */
  textColor?: string | null,
  /**
   * 协议链接文字颜色
   *
   * 格式为"#RRGGBB"，默认值为"#1d4788"。
   */
  termsColor?: string | null,
  /**
   * 服务协议前文本内容
   *
   * 默认值为"我已阅读并同意"。
   */
  prefix?: string | null,
  /**
   * 服务协议后文本内容
   *
   * 默认值为"并使用本机号码登录"。
   */
  suffix?: string | null,
  /**
   * 字体大小
   *
   * 格式为“XXpx"，默认值为"12px"。
   */
  fontSize?: string | null,
  /**
   * 服务协议
   *
   * 自定义服务协议，可设置使用手机号码登录的协议，最多可设置两个协议。 注意：运营商的服务协议链接会自动添加到自定义服务协议之前。
   */
  privacyItems?: (UniverifyPrivacyItemStyles[]) | null
};
export type UniVerifyButtonListItem = {
  /**
   * 该按钮标识，会原样返回。
   */
  provider: string,
  /**
   * 图片路径
   *
   * 仅支持本地图片
   */
  iconPath: string
};
export type UniVerifyButtonsStyles = {
  /**
   * 自定义登录按钮图标宽度
   *
   * 单位为px，默认值为45px。
   *                     按指定宽度缩放，高度等比例缩放。
   */
  iconWidth?: string | null,
  /**
   * 自定义登录按钮列表
   */
  list: UniVerifyButtonListItem[]
};
export type UniverifyStyle = {
  /**
   * 是否全屏模式。
   *
   * true表示全屏模式，false表示非全屏模式，默认值为false。
   * @type boolean
   */
  fullScreen?: boolean | null,
  /**
   * 授权界面背景颜色。
   *
   * 格式为"#RRGGBB"，默认值为"#FFFFF"。
   */
  backgroundColor?: string | null,
  /**
   * 背景图片
   */
  backgroundImage?: string | null,
  /**
   * 授权界面图标样式。
   *
   * 可设置自定义图标，默认为应用图标。
   */
  icon?: UniverifyIconStyles | null,
  /**
   * 授权界面电话号码样式
   *
   * 可设置自定义电话号码文字颜色、大小等。
   */
  phoneNum?: UniverifyPhoneNumStyles | null,
  /**
   * 授权界面服务说明样式
   *
   * 可设置自定义服务说明文字颜色、大小等。
   */
  slogan?: UniverifySloganStyles | null,
  /**
   * 授权界面其他登录按钮样式
   *
   * 可设置自定义其他登录按钮背景颜色、文本内容、大小等。
   */
  authButton?: UniverifyAuthButtonStyles | null,
  /**
   * 支付宝小程序登录成功的授权 scope
   */
  otherLoginButton?: UniverifyOtherButtonStyles | null,
  /**
   * 授权界面服务协议样式
   *
   * 自定义设置服务器协议文字颜色、文本内容，添加自定义服务协议链接等。
   */
  privacyTerms?: UniverifyPrivacyTermsStyles | null,
  /**
   * 自定义登录按钮列表样式
   *
   * 自定义设置更多登录按钮列表，如其它三方登录等。
   *                     注意：HBuilderX3.1.14+版本支持。
   */
  buttons?: UniVerifyButtonsStyles | null
};
export type GetUserInfo = (options: GetUserInfoOptions) => void;
export type UserInfo = {
  /**
   * 用户昵称
     * @uniPlatform {
     *   "mp": {
     *     "weixin": {
     *       "hostVer": "√",
     *       "uniVer": "√",
     *       "unixVer": "4.41"
     *     },
     *     "alipay": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "baidu": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "toutiao": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "lark": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "qq": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "kuaishou": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "jd": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     }
     *   }
     * }
     */
  nickName: string,
  /**
   * 该服务商唯一用户标识
   * @uniPlatform {
   *  "app": {
   *    "android": {
   *        "osVer": "5.0",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *      },
   *      "ios": {
   *          "osVer": "12.0",
   *          "uniVer": "√",
   *          "unixVer": "x"
   *      },
   *    "harmony": {
   *      "osVer": "3.0",
   *      "uniVer": "4.27",
   *      "unixVer": "4.61"
   *    }
   *  },
   *  "mp": {
   *    "weixin": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "alipay": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "baidu": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "toutiao": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "lark": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "qq": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "kuaishou": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "jd": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "360": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    }
   *  },
   *  "quickapp": {
   *      "uniVer": "x",
   *      "unixVer": "x"
   *  },
   *  "web": {
   *      "uniVer": "x",
   *      "unixVer": "x"
   *  }
   * }
   */
  openId?: string | null,
  /**
   * 用户头像
   * @uniPlatform {
   *   "mp": {
   *     "weixin": {
   *       "hostVer": "√",
   *       "uniVer": "√",
   *       "unixVer": "4.41"
   *     },
   *     "alipay": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "baidu": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "toutiao": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "lark": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "qq": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "kuaishou": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "jd": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     }
   *   }
   * }
   */
  avatarUrl: string
    /**
     * @tutorial_weixin https://developers.weixin.qq.com/community/develop/doc/00028edbe3c58081e7cc834705b801
     *
     * @uniPlatform {
     *   "mp": {
     *     "weixin": {
     *       "hostVer": "√",
     *       "uniVer": "√",
     *       "unixVer": "4.41"
     *     },
     *     "alipay": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "baidu": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "toutiao": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "lark": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "qq": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "kuaishou": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "jd": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     }
     *   }
     * }
     */
    city?: string | null;
    /**
     * @tutorial_weixin https://developers.weixin.qq.com/community/develop/doc/00028edbe3c58081e7cc834705b801
     *
     * @uniPlatform {
     *   "mp": {
     *     "weixin": {
     *       "hostVer": "√",
     *       "uniVer": "√",
     *       "unixVer": "4.41"
     *     },
     *     "alipay": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "baidu": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "toutiao": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "lark": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "qq": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "kuaishou": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "jd": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     }
     *   }
     * }
     */
    country?: string | null;
    /**
     * 可选值：
     * - 0: 未知;
     * - 1: 男性;
     * - 2: 女性;
     *
     * @tutorial_weixin https://developers.weixin.qq.com/community/develop/doc/00028edbe3c58081e7cc834705b801
     *
     * @uniPlatform {
     *   "mp": {
     *     "weixin": {
     *       "hostVer": "√",
     *       "uniVer": "√",
     *       "unixVer": "4.41"
     *     },
     *     "alipay": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "baidu": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "toutiao": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "lark": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "qq": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "kuaishou": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "jd": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     }
     *   }
     * }
     */
    gender?: 0 | 1 | 2 | null;
    /**
     * 可选值：
     * - 'en': 英文;
     * - 'zh_CN': 简体中文;
     * - 'zh_TW': 繁体中文;
     *
     * @tutorial_weixin https://developers.weixin.qq.com/community/develop/doc/00028edbe3c58081e7cc834705b801
     *
     * @uniPlatform {
     *   "mp": {
     *     "weixin": {
     *       "hostVer": "√",
     *       "uniVer": "√",
     *       "unixVer": "4.41"
     *     },
     *     "alipay": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "baidu": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "toutiao": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "lark": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "qq": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "kuaishou": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "jd": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     }
     *   }
     * }
     */
    language?: "en" | "zh_CN" | "zh_TW" | null;
    /**
     * @tutorial_weixin https://developers.weixin.qq.com/community/develop/doc/00028edbe3c58081e7cc834705b801
     *
     * @uniPlatform {
     *   "mp": {
     *     "weixin": {
     *       "hostVer": "√",
     *       "uniVer": "√",
     *       "unixVer": "4.41"
     *     },
     *     "alipay": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "baidu": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "toutiao": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "lark": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "qq": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "kuaishou": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "jd": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     }
     *   }
     * }
     */
    province?: string | null;
};
export type GetUserInfoSuccess = {
  /**
   * 用户信息对象，不包含 openid 等敏感信息
   * @uniPlatform {
   *  "app": {
   *    "android": {
   *        "osVer": "5.0",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *      },
   *      "ios": {
   *          "osVer": "12.0",
   *          "uniVer": "√",
   *          "unixVer": "x"
   *      },
   *    "harmony": {
   *      "osVer": "3.0",
   *      "uniVer": "4.27",
   *      "unixVer": "4.61"
   *    }
   *  },
   *  "mp": {
   *    "weixin": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "4.41"
   *    },
   *    "alipay": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *    },
   *    "baidu": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *    },
   *    "toutiao": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *    },
   *    "lark": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *    },
   *    "qq": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *    },
   *    "kuaishou": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *    },
   *    "jd": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *    },
   *    "360": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    }
   *  },
   *  "quickapp": {
   *      "uniVer": "x",
   *      "unixVer": "x"
   *  },
   *  "web": {
   *      "uniVer": "x",
   *      "unixVer": "x"
   *  }
   * }
   */
  userInfo: UserInfo,
  /**
   * 不包括敏感信息的原始数据字符串，用于计算签名。
   * @uniPlatform {
   *  "app": {
   *    "android": {
   *        "osVer": "5.0",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *      },
   *      "ios": {
   *          "osVer": "12.0",
   *          "uniVer": "x",
   *          "unixVer": "x"
   *      },
   *    "harmony": {
   *      "osVer": "3.0",
   *      "uniVer": "x",
   *      "unixVer": "x"
   *    }
   *  },
   *  "mp": {
   *    "weixin": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "4.41"
   *    },
   *    "alipay": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "baidu": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "toutiao": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *    },
   *    "lark": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *    },
   *    "qq": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "kuaishou": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *    },
   *    "jd": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *    },
   *    "360": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    }
   *  },
   *  "quickapp": {
   *      "uniVer": "x",
   *      "unixVer": "x"
   *  },
   *  "web": {
   *      "uniVer": "x",
   *      "unixVer": "x"
   *  }
   * }
   */
  rawData?: string | null,
  /**
   * 使用 sha1( rawData + sessionkey ) 得到字符串，用于校验用户信息，仅微信小程序生效。
   * @uniPlatform {
   *  "app": {
   *    "android": {
   *        "osVer": "5.0",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *      },
   *      "ios": {
   *          "osVer": "12.0",
   *          "uniVer": "x",
   *          "unixVer": "x"
   *      },
   *    "harmony": {
   *      "osVer": "3.0",
   *      "uniVer": "x",
   *      "unixVer": "x"
   *    }
   *  },
   *  "mp": {
   *    "weixin": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "4.41"
   *    },
   *    "alipay": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "baidu": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "toutiao": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *    },
   *    "lark": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *    },
   *    "qq": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "kuaishou": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *    },
   *    "jd": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *    },
   *    "360": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    }
   *  },
   *  "quickapp": {
   *      "uniVer": "x",
   *      "unixVer": "x"
   *  },
   *  "web": {
   *      "uniVer": "x",
   *      "unixVer": "x"
   *  }
   * }
   */
  signature?: string | null,
  /**
   * 包括敏感数据在内的完整用户信息的加密数据，详细见加密数据解密算法，仅微信小程序生效。
   * @uniPlatform {
   *  "app": {
   *    "android": {
   *        "osVer": "5.0",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *      },
   *      "ios": {
   *          "osVer": "12.0",
   *          "uniVer": "x",
   *          "unixVer": "x"
   *      },
   *    "harmony": {
   *      "osVer": "3.0",
   *      "uniVer": "x",
   *      "unixVer": "x"
   *    }
   *  },
   *  "mp": {
   *    "weixin": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "4.41"
   *    },
   *    "alipay": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "baidu": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "toutiao": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *    },
   *    "lark": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *    },
   *    "qq": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "kuaishou": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *    },
   *    "jd": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *    },
   *    "360": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    }
   *  },
   *  "quickapp": {
   *      "uniVer": "x",
   *      "unixVer": "x"
   *  },
   *  "web": {
   *      "uniVer": "x",
   *      "unixVer": "x"
   *  }
   * }
   */
  encryptedData?: string | null,
  /**
   * 加密算法的初始向量，详细见加密数据解密算法，仅微信小程序生效。
   * @uniPlatform {
   *  "app": {
   *    "android": {
   *        "osVer": "5.0",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *      },
   *      "ios": {
   *          "osVer": "12.0",
   *          "uniVer": "x",
   *          "unixVer": "x"
   *      },
   *    "harmony": {
   *      "osVer": "3.0",
   *      "uniVer": "x",
   *      "unixVer": "x"
   *    }
   *  },
   *  "mp": {
   *    "weixin": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "4.41"
   *    },
   *    "alipay": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "baidu": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "toutiao": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *    },
   *    "lark": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *    },
   *    "qq": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "kuaishou": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *    },
   *    "jd": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *    },
   *    "360": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    }
   *  },
   *  "quickapp": {
   *      "uniVer": "x",
   *      "unixVer": "x"
   *  },
   *  "web": {
   *      "uniVer": "x",
   *      "unixVer": "x"
   *  }
   * }
   */
  iv?: string | null,
  /**
   * 描述信息
   * @uniPlatform {
   *   "mp": {
   *     "weixin": {
   *       "hostVer": "√",
   *       "uniVer": "√",
   *       "unixVer": "4.41"
   *     },
   *     "alipay": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "baidu": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "toutiao": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "lark": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "qq": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "kuaishou": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "jd": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     }
   *   }
   * }
   */
  errMsg: string
    /**
     * 需要基础库： `2.7.0`
     *
     * 敏感数据对应的云 ID，开通[云开发](https://developers.weixin.qq.com/miniprogram/dev/wxcloud/basis/getting-started.html)的小程序才会返回，可通过云调用直接获取开放数据，详细见[云调用直接获取开放数据](https://developers.weixin.qq.com/miniprogram/dev/framework/open-ability/signature.html#method-cloud)
     *
     * @uniPlatform {
     *   "mp": {
     *     "weixin": {
     *       "hostVer": "2.7.0",
     *       "uniVer": "√",
     *       "unixVer": "4.41"
     *     },
     *     "alipay": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "baidu": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "toutiao": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "lark": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "qq": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "kuaishou": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     },
     *     "jd": {
     *       "hostVer": "-",
     *       "uniVer": "-",
     *       "unixVer": "-"
     *     }
     *   }
     * }
     */
    cloudID?: string | null;
};
export type GetUserInfoSuccessCallback = (result: GetUserInfoSuccess) => void;
export type GetUserInfoFail = IUniError;
export type GetUserInfoFailCallback = (result: GetUserInfoFail) => void;
export type GetUserInfoComplete = any;
export type GetUserInfoCompleteCallback = (result: GetUserInfoComplete) => void;
export type GetUserInfoOptions = {
  /**
   * 授权登录服务提供商，通过uni.getProvider获取
   * @uniPlatform {
   *  "app": {
   *    "android": {
   *        "osVer": "5.0",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *      },
   *      "ios": {
   *          "osVer": "12.0",
   *          "uniVer": "√",
   *          "unixVer": "x"
   *      },
   *    "harmony": {
   *      "osVer": "3.0",
   *      "uniVer": "4.27",
   *      "unixVer": "4.61"
   *    }
   *  },
   *  "mp": {
   *    "weixin": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "alipay": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "baidu": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "toutiao": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "lark": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "qq": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "kuaishou": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "jd": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "360": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    }
   *  },
   *  "quickapp": {
   *      "uniVer": "x",
   *      "unixVer": "x"
   *  },
   *  "web": {
   *      "uniVer": "x",
   *      "unixVer": "x"
   *  }
   * }
   */
  provider?:
  /**
   * 微信登录
   */
  'weixin' |
  /**
   * QQ登录
   */
  'qq' |
  /**
   * 新浪微博登录
   */
  'sinaweibo' |
  /**
   * 小米登录
   */
  'xiaomi' |
  /**
   * Apple登录
   */
  'apple' |
  /**
   * 华为 HarmonyOS Next 华为账号登录
   */
  'huawei' | null,
  /**
   * 是否带上登录态信息，仅微信小程序生效。
   * @uniPlatform {
   *  "app": {
   *    "android": {
   *        "osVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *      },
   *      "ios": {
   *        "osVer": "x",
   *          "uniVer": "x",
   *          "unixVer": "x"
   *      },
   *    "harmony": {
   *        "osVer": "x",
   *          "uniVer": "x",
   *      "unixVer": "x"
   *    }
   *  },
   *  "mp": {
   *    "weixin": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "4.41"
   *    },
   *    "alipay": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "baidu": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "toutiao": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *    },
   *    "lark": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *    },
   *    "qq": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "kuaishou": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "x"
   *    },
   *    "jd": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "360": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    }
   *  },
   *  "quickapp": {
   *      "uniVer": "x",
   *      "unixVer": "x"
   *  },
   *  "web": {
   *      "uniVer": "x",
   *      "unixVer": "x"
   *  }
   * }
   */
  withCredentials?: boolean | null,
  /**
   * 指定返回用户信息的语言，zh_CN 简体中文，zh_TW 繁体中文，en 英文。默认为en，仅微信小程序生效。
   * @uniPlatform {
   *  "app": {
   *    "android": {
   *        "osVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *      },
   *      "ios": {
   *        "osVer": "x",
   *          "uniVer": "x",
   *          "unixVer": "x"
   *      },
   *    "harmony": {
   *        "osVer": "x",
   *          "uniVer": "x",
   *      "unixVer": "x"
   *    }
   *  },
   *  "mp": {
   *    "weixin": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "4.41"
   *    },
   *    "alipay": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "baidu": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "toutiao": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "lark": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "qq": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "kuaishou": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "jd": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "360": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    }
   *  },
   *  "quickapp": {
   *      "uniVer": "x",
   *      "unixVer": "x"
   *  },
   *  "web": {
   *      "uniVer": "x",
   *      "unixVer": "x"
   *  }
   * }
   */
  lang?: string | null,
  /**
   * 超时时间，单位 ms
   * @uniPlatform {
   *  "app": {
   *    "android": {
   *        "osVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *      },
   *      "ios": {
   *        "osVer": "x",
   *          "uniVer": "x",
   *          "unixVer": "x"
   *      },
   *    "harmony": {
   *        "osVer": "x",
   *          "uniVer": "x",
   *      "unixVer": "x"
   *    }
   *  },
   *  "mp": {
   *    "weixin": {
   *        "hostVer": "√",
   *        "uniVer": "√",
   *        "unixVer": "4.41"
   *    },
   *    "alipay": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "baidu": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "toutiao": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "lark": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "qq": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "kuaishou": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "jd": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    },
   *    "360": {
   *        "hostVer": "x",
   *        "uniVer": "x",
   *        "unixVer": "x"
   *    }
   *  },
   *  "quickapp": {
   *      "uniVer": "x",
   *      "unixVer": "x"
   *  },
   *  "web": {
   *      "uniVer": "x",
   *      "unixVer": "x"
   *  }
   * }
   */
  timeout?: number | null,
  /**
   * 接口调用成功的回调函数
   * @uniPlatform {
   *   "mp": {
   *     "weixin": {
   *       "hostVer": "√",
   *       "uniVer": "√",
   *       "unixVer": "4.41"
   *     },
   *     "alipay": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "baidu": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "toutiao": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "lark": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "qq": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "kuaishou": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "jd": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     }
   *   }
   * }
   */
  success?: GetUserInfoSuccessCallback | null,
  /**
   * 接口调用失败的回调函数
   * @uniPlatform {
   *   "mp": {
   *     "weixin": {
   *       "hostVer": "√",
   *       "uniVer": "√",
   *       "unixVer": "4.41"
   *     },
   *     "alipay": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "baidu": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "toutiao": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "lark": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "qq": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "kuaishou": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "jd": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     }
   *   }
   * }
   */
  fail?: GetUserInfoFailCallback | null,
  /**
   * 接口调用结束的回调函数（调用成功、失败都会执行）
   * @uniPlatform {
   *   "mp": {
   *     "weixin": {
   *       "hostVer": "√",
   *       "uniVer": "√",
   *       "unixVer": "4.41"
   *     },
   *     "alipay": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "baidu": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "toutiao": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "lark": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "qq": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "kuaishou": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     },
   *     "jd": {
   *       "hostVer": "-",
   *       "uniVer": "-",
   *       "unixVer": "-"
   *     }
   *   }
   * }
   */
  complete?: GetUserInfoCompleteCallback | null
};
