export interface Uni {
    /**
     * 拨打电话
     * @tutorial https://uniapp.dcloud.net.cn/api/system/phone.html#makephonecall
     * @tutorial-uni-app https://uniapp.dcloud.net.cn/api/system/phone.html#makephonecall
     * @uniPlatform {
     *   "app": {
     *     "android": {
     *       "osVer": "5.0",
     *       "uniVer": "√",
     *       "unixVer": "4.63",
     *       "unixUtsPlugin": "4.63"
     *     },
     *     "ios": {
     *       "osVer": "12.0",
     *       "uniVer": "√",
     *       "unixVer": "4.63",
     *       "unixUtsPlugin": "4.63"
     *     },
     *     "harmony": {
     *       "osVer": "3.0",
     *       "uniVer": "4.23",
     *       "unixVer": "4.61",
     *       "unixUtsPlugin": "4.61"
     *     }
     *   },
     *   "mp": {
     *     "weixin": {
     *       "hostVer": "1.9.6",
     *       "uniVer": "√",
     *       "unixVer": "4.41"
     *     },
     *     "alipay": {
     *       "hostVer": "√",
     *       "uniVer": "√",
     *       "unixVer": "x"
     *     },
     *     "baidu": {
     *       "hostVer": "√",
     *       "uniVer": "√",
     *       "unixVer": "x"
     *     },
     *     "toutiao": {
     *       "hostVer": "√",
     *       "uniVer": "√",
     *       "unixVer": "x"
     *     },
     *     "lark": {
     *       "hostVer": "√",
     *       "uniVer": "√",
     *       "unixVer": "√"
     *     },
     *     "qq": {
     *       "hostVer": "√",
     *       "uniVer": "√",
     *       "unixVer": "x"
     *     },
     *     "kuaishou": {
     *       "hostVer": "√",
     *       "uniVer": "√",
     *       "unixVer": "x"
     *     },
     *     "jd": {
     *       "hostVer": "√",
     *       "uniVer": "√",
     *       "unixVer": "x"
     *     }
     *   },
     *   "web": {
     *     "uniVer": "√",
     *     "unixVer": "4.0"
     *   }
     * }
     * @tutorial_weixin https://developers.weixin.qq.com/miniprogram/dev/api/device/phone/wx.makePhoneCall.html
     */
    makePhoneCall(options: MakePhoneCallOptions): void;
}

export type MakePhoneCall = (options: MakePhoneCallOptions) => void;
export type MakePhoneCallSuccess = {};
export type MakePhoneCallSuccessCallback = (result: MakePhoneCallSuccess) => void;
export type MakePhoneCallErrorCode =
	/**
	 * 当前设备不支持此功能
	 */
	1500601 |
	/**
	 * 无效号码
	 */
	1500602 |
	/**
	 * 内部错误
	 */
	1500603;
export interface IMakePhoneCallError extends IUniError {
	errCode : MakePhoneCallErrorCode;
}
export type MakePhoneCallFail = IMakePhoneCallError;
export type MakePhoneCallFailCallback = (result: MakePhoneCallFail) => void;
export type MakePhoneCallComplete = any;
export type MakePhoneCallCompleteCallback = (result: MakePhoneCallComplete) => void;
export type MakePhoneCallOptions = {
    /**
     * 需要拨打的电话号码
     * @uniPlatform {
     *  "app": {
     *    "android": {
     *      "osVer": "5.0",
     *      "uniVer": "√",
     *      "unixVer": "4.63",
	 *  	"unixUtsPlugin": "4.63" 
     *    },
     *    "ios": {
     *      "osVer": "12.0",
     *      "uniVer": "√",
     *      "unixVer": "4.63",
	 *   	"unixUtsPlugin": "4.63"
     *    },
     *    "harmony": {
     *      "osVer": "3.0",
     *      "uniVer": "4.23",
     *      "unixVer": "4.61",
	 *   	"unixUtsPlugin": "4.61"
     *    }
     *  },
     *  "mp": {
     *    "weixin": {
     *      "hostVer": "√",
     *      "uniVer": "√",
     *      "unixVer": "4.41"
     *    },
     *    "alipay": {
     *      "hostVer": "√",
     *      "uniVer": "√",
     *      "unixVer": "x"
     *    },
     *    "baidu": {
     *      "hostVer": "√",
     *      "uniVer": "√",
     *      "unixVer": "x"
     *    },
     *    "toutiao": {
     *      "hostVer": "√",
     *      "uniVer": "√",
     *      "unixVer": "x"
     *    },
     *    "lark": {
     *      "hostVer": "√",
     *      "uniVer": "√",
     *      "unixVer": "√"
     *    },
     *    "qq": {
     *      "hostVer": "√",
     *      "uniVer": "√",
     *      "unixVer": "x"
     *    },
     *    "kuaishou": {
     *      "hostVer": "√",
     *      "uniVer": "√",
     *      "unixVer": "x"
     *    },
     *    "jd": {
     *      "hostVer": "√",
     *      "uniVer": "√",
     *      "unixVer": "x"
     *    }
     *  },
     *  "web": {
     *    "uniVer": "√",
     *    "unixVer": "4.0"
     *  }
     * }
     */
    phoneNumber: string,
    /**
     * 成功返回的回调函数
	 * @uniPlatform {
	 *  "app": {
	 *    "android": {
	 *      "osVer": "5.0",
	 *      "uniVer": "√",
	 *      "unixVer": "4.63",
	 *  	"unixUtsPlugin": "4.63" 
	 *    },
	 *    "ios": {
	 *      "osVer": "12.0",
	 *      "uniVer": "√",
	 *      "unixVer": "4.63",
	 *   	"unixUtsPlugin": "4.63"
	 *    },
	 *    "harmony": {
	 *      "osVer": "3.0",
	 *      "uniVer": "4.23",
	 *      "unixVer": "4.61",
	 *   	"unixUtsPlugin": "4.61"
	 *    }
	 *  },
	 *  "mp": {
	 *    "weixin": {
	 *      "hostVer": "√",
	 *      "uniVer": "√",
	 *      "unixVer": "4.41"
	 *    },
	 *    "alipay": {
	 *      "hostVer": "√",
	 *      "uniVer": "√",
	 *      "unixVer": "x"
	 *    },
	 *    "baidu": {
	 *      "hostVer": "√",
	 *      "uniVer": "√",
	 *      "unixVer": "x"
	 *    },
	 *    "toutiao": {
	 *      "hostVer": "√",
	 *      "uniVer": "√",
	 *      "unixVer": "x"
	 *    },
	 *    "lark": {
	 *      "hostVer": "√",
	 *      "uniVer": "√",
	 *      "unixVer": "√"
	 *    },
	 *    "qq": {
	 *      "hostVer": "√",
	 *      "uniVer": "√",
	 *      "unixVer": "x"
	 *    },
	 *    "kuaishou": {
	 *      "hostVer": "√",
	 *      "uniVer": "√",
	 *      "unixVer": "x"
	 *    },
	 *    "jd": {
	 *      "hostVer": "√",
	 *      "uniVer": "√",
	 *      "unixVer": "x"
	 *    }
	 *  },
	 *  "web": {
	 *    "uniVer": "√",
	 *    "unixVer": "4.0"
	 *  }
	 * }
     */
    success?: MakePhoneCallSuccessCallback | null,
    /**
     * 失败的回调函数
	 * @uniPlatform {
	 *  "app": {
	 *    "android": {
	 *      "osVer": "5.0",
	 *      "uniVer": "√",
	 *      "unixVer": "4.63",
	 *  	"unixUtsPlugin": "4.63" 
	 *    },
	 *    "ios": {
	 *      "osVer": "12.0",
	 *      "uniVer": "√",
	 *      "unixVer": "4.63",
	 *   	"unixUtsPlugin": "4.63"
	 *    },
	 *    "harmony": {
	 *      "osVer": "3.0",
	 *      "uniVer": "4.23",
	 *      "unixVer": "4.61",
	 *   	"unixUtsPlugin": "4.61"
	 *    }
	 *  },
	 *  "mp": {
	 *    "weixin": {
	 *      "hostVer": "√",
	 *      "uniVer": "√",
	 *      "unixVer": "4.41"
	 *    },
	 *    "alipay": {
	 *      "hostVer": "√",
	 *      "uniVer": "√",
	 *      "unixVer": "x"
	 *    },
	 *    "baidu": {
	 *      "hostVer": "√",
	 *      "uniVer": "√",
	 *      "unixVer": "x"
	 *    },
	 *    "toutiao": {
	 *      "hostVer": "√",
	 *      "uniVer": "√",
	 *      "unixVer": "x"
	 *    },
	 *    "lark": {
	 *      "hostVer": "√",
	 *      "uniVer": "√",
	 *      "unixVer": "√"
	 *    },
	 *    "qq": {
	 *      "hostVer": "√",
	 *      "uniVer": "√",
	 *      "unixVer": "x"
	 *    },
	 *    "kuaishou": {
	 *      "hostVer": "√",
	 *      "uniVer": "√",
	 *      "unixVer": "x"
	 *    },
	 *    "jd": {
	 *      "hostVer": "√",
	 *      "uniVer": "√",
	 *      "unixVer": "x"
	 *    }
	 *  },
	 *  "web": {
	 *    "uniVer": "√",
	 *    "unixVer": "4.0"
	 *  }
	 * }
     */
    fail?: MakePhoneCallFailCallback | null,
    /**
     * 结束的回调函数（调用成功、失败都会执行）
	 * @uniPlatform {
	 *  "app": {
	 *    "android": {
	 *      "osVer": "5.0",
	 *      "uniVer": "√",
	 *      "unixVer": "4.63",
	 *  	"unixUtsPlugin": "4.63" 
	 *    },
	 *    "ios": {
	 *      "osVer": "12.0",
	 *      "uniVer": "√",
	 *      "unixVer": "4.63",
	 *   	"unixUtsPlugin": "4.63"
	 *    },
	 *    "harmony": {
	 *      "osVer": "3.0",
	 *      "uniVer": "4.23",
	 *      "unixVer": "4.61",
	 *   	"unixUtsPlugin": "4.61"
	 *    }
	 *  },
	 *  "mp": {
	 *    "weixin": {
	 *      "hostVer": "√",
	 *      "uniVer": "√",
	 *      "unixVer": "4.41"
	 *    },
	 *    "alipay": {
	 *      "hostVer": "√",
	 *      "uniVer": "√",
	 *      "unixVer": "x"
	 *    },
	 *    "baidu": {
	 *      "hostVer": "√",
	 *      "uniVer": "√",
	 *      "unixVer": "x"
	 *    },
	 *    "toutiao": {
	 *      "hostVer": "√",
	 *      "uniVer": "√",
	 *      "unixVer": "x"
	 *    },
	 *    "lark": {
	 *      "hostVer": "√",
	 *      "uniVer": "√",
	 *      "unixVer": "√"
	 *    },
	 *    "qq": {
	 *      "hostVer": "√",
	 *      "uniVer": "√",
	 *      "unixVer": "x"
	 *    },
	 *    "kuaishou": {
	 *      "hostVer": "√",
	 *      "uniVer": "√",
	 *      "unixVer": "x"
	 *    },
	 *    "jd": {
	 *      "hostVer": "√",
	 *      "uniVer": "√",
	 *      "unixVer": "x"
	 *    }
	 *  },
	 *  "web": {
	 *    "uniVer": "√",
	 *    "unixVer": "4.0"
	 *  }
	 * }
     */
    complete?: MakePhoneCallCompleteCallback | null
};
