const {
  ID,
  C_IS,
  C_REF,
  C_NAME,
  V_IF,
  V_FOR,
  V_ELSE_IF,
  isVar
} = require('../util')

const parseTextExpr = require('./text-parser')

function parseRef (el, genVar) {
  if (el.ref && isVar(el.ref)) {
    el.ref = genVar(C_REF, el.ref)
  }
}

function parseSlotName (el, genVar) {
  if (el.slotName && isVar(el.slotName)) {
    el.slotName = genVar(C_NAME, el.slotName)
  }
}

function parseIs (el, genVar) {
  if (!el.component) {
    return
  }
  if (isVar(el.component)) {
    el.component = genVar(C_IS, el.component)
  }
}

function isProcessed (exp) {
  return String(exp).indexOf('_$') === 0
}
// 当根节点是由if,elseif,else组成，会调用多次parseIf来解析root
function parseIf (el, createGenVar, isScopedSlot) {
  if (!el.if) {
    return
  }
  if (el.slotTarget && el.tag === 'template') { // new v-slot
    isScopedSlot = false
  }
  el.ifConditions.forEach(con => {
    if (!isProcessed(con.exp) && isVar(con.exp)) {
      con.exp = createGenVar(con.block.attrsMap[ID], isScopedSlot)(con.block.elseif ? V_ELSE_IF : V_IF, con.exp)
    }
  })
  if (!isProcessed(el.if)) {
    el.if = createGenVar(el.attrsMap[ID], isScopedSlot)(V_IF, el.if)
  }
}

function parseFor (el, createGenVar, isScopedSlot, fill = false) {
  if (el.for && isVar(el.for)) {
    el.for = createGenVar(el.forId, isScopedSlot)(
      V_FOR,
      fill
        ? `{forItems:${el.for},fill:true}`
        : `{forItems:${el.for}}`
    )
    return true
  }
}

function parseBinding (el, genVar) {
  el.staticClass && (el.staticClass = genVar('sc', el.staticClass))
  el.classBinding && (el.classBinding = genVar('c', el.classBinding))
  el.styleBinding && (el.styleBinding = genVar('s', el.styleBinding))
}

function parseDirs (el, genVar, ignoreDirs = []) {
  el.directives && el.directives.forEach(dir => {
    if (ignoreDirs.indexOf(dir.name) === -1) {
      dir.value && (dir.value = genVar('v-' + dir.name, dir.value))
      dir.isDynamicArg && (dir.arg = genVar('v-' + dir.name + '-arg', dir.arg))
    }
  })
}

function parseAttrs (el, genVar) {
  el.attrs && el.attrs.forEach(attr => {
    const {
      name,
      value
    } = attr
    if (
      name !== ID &&
      // name.indexOf('data-') !== 0 && // TODO dataset 保留
      name.indexOf('change:') !== 0 && // wxs change:prop
      isVar(value) &&
      value.indexOf('_$') !== 0 // 已被提前处理过了，如 wxs prop:_$gc(2,'change:prop')
    ) {
      attr.value = genVar('a-' + name, value)
    }
  })
}

function parseProps (el, genVar) {
  el.props && el.props.forEach(prop => {
    isVar(prop.value) && (prop.value = genVar('a-' + prop.name, prop.value))
  })
}

function parseText (el, parent, state) {
  // fixed by xxxxxx 注意：保持平台一致性，trim 一下
  el.parent && (el.parent = parent)
  el.expression = parseTextExpr(el.text.trim(), false, state).expression
}

module.exports = {
  parseIs,
  parseRef,
  parseSlotName,
  parseIf,
  parseFor,
  parseText,
  parseDirs,
  parseAttrs,
  parseProps,
  parseBinding
}
