const isWin = /^win/.test(process.platform)

const normalizePath = path => (isWin ? path.replace(/\\/g, '/') : path)

const camelizeRE = /-(\w)/g

function camelize (str) {
  return str.replace(camelizeRE, (_, c) => c ? c.toUpperCase() : '')
}

/**
 * Capitalize a string.
 */
function capitalize (str) {
  return str.charAt(0).toUpperCase() + str.slice(1)
}

module.exports = {
  camelize,
  capitalize,
  normalizePath
}
